%------------------------------------------------------------------------------
% File     : ITP021^7 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 syntactic export of thm_2Eextreal_2Emax__le.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Eextreal_2Emax__le.p [Gau20]
%          : HL410001^7.p [TPAP]

% Status   : Theorem
% Rating   : 0.67 v8.1.0, 0.50 v7.5.0
% Syntax   : Number of formulae    : 22112 (5611 unt;8235 typ;   0 def)
%            Number of atoms       : 51528 (18600 equ;2582 cnn)
%            Maximal formula atoms :  912 (   3 avg)
%            Number of connectives : 364863 (2582   ~;1189   |;12404   &;336146   @)
%                                         (5422 <=>;7120  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  364 (   8 avg)
%            Number of types       :   24 (  23 usr)
%            Number of type conns  : 34909 (34909   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 2328 (2326 usr;  88 con; 0-11 aty)
%            Number of variables   : 75459 (4301   ^;51366   !;13958   ?;75459   :)
%                                         (5834  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP002^7.ax').
include('Axioms/ITP001/ITP003^7.ax').
include('Axioms/ITP001/ITP004^7.ax').
include('Axioms/ITP001/ITP005^7.ax').
include('Axioms/ITP001/ITP006^7.ax').
include('Axioms/ITP001/ITP007^7.ax').
include('Axioms/ITP001/ITP008^7.ax').
include('Axioms/ITP001/ITP009^7.ax').
include('Axioms/ITP001/ITP010^7.ax').
include('Axioms/ITP001/ITP011^7.ax').
include('Axioms/ITP001/ITP012^7.ax').
include('Axioms/ITP001/ITP013^7.ax').
include('Axioms/ITP001/ITP014^7.ax').
include('Axioms/ITP001/ITP015^7.ax').
include('Axioms/ITP001/ITP016^7.ax').
include('Axioms/ITP001/ITP017^7.ax').
include('Axioms/ITP001/ITP018^7.ax').
include('Axioms/ITP001/ITP019^7.ax').
include('Axioms/ITP001/ITP020^7.ax').
include('Axioms/ITP001/ITP021^7.ax').
include('Axioms/ITP001/ITP022^7.ax').
include('Axioms/ITP001/ITP023^7.ax').
include('Axioms/ITP001/ITP024^7.ax').
include('Axioms/ITP001/ITP025^7.ax').
include('Axioms/ITP001/ITP026^7.ax').
include('Axioms/ITP001/ITP027^7.ax').
include('Axioms/ITP001/ITP028^7.ax').
include('Axioms/ITP001/ITP029^7.ax').
include('Axioms/ITP001/ITP030^7.ax').
include('Axioms/ITP001/ITP031^7.ax').
include('Axioms/ITP001/ITP032^7.ax').
include('Axioms/ITP001/ITP033^7.ax').
include('Axioms/ITP001/ITP034^7.ax').
include('Axioms/ITP001/ITP035^7.ax').
include('Axioms/ITP001/ITP036^7.ax').
include('Axioms/ITP001/ITP037^7.ax').
include('Axioms/ITP001/ITP038^7.ax').
include('Axioms/ITP001/ITP039^7.ax').
include('Axioms/ITP001/ITP040^7.ax').
include('Axioms/ITP001/ITP041^7.ax').
include('Axioms/ITP001/ITP042^7.ax').
include('Axioms/ITP001/ITP043^7.ax').
include('Axioms/ITP001/ITP044^7.ax').
include('Axioms/ITP001/ITP045^7.ax').
include('Axioms/ITP001/ITP046^7.ax').
include('Axioms/ITP001/ITP047^7.ax').
include('Axioms/ITP001/ITP048^7.ax').
include('Axioms/ITP001/ITP049^7.ax').
include('Axioms/ITP001/ITP050^7.ax').
include('Axioms/ITP001/ITP051^7.ax').
include('Axioms/ITP001/ITP052^7.ax').
include('Axioms/ITP001/ITP053^7.ax').
include('Axioms/ITP001/ITP054^7.ax').
include('Axioms/ITP001/ITP055^7.ax').
include('Axioms/ITP001/ITP056^7.ax').
include('Axioms/ITP001/ITP057^7.ax').
include('Axioms/ITP001/ITP058^7.ax').
include('Axioms/ITP001/ITP059^7.ax').
include('Axioms/ITP001/ITP060^7.ax').
include('Axioms/ITP001/ITP061^7.ax').
include('Axioms/ITP001/ITP062^7.ax').
include('Axioms/ITP001/ITP063^7.ax').
include('Axioms/ITP001/ITP064^7.ax').
include('Axioms/ITP001/ITP065^7.ax').
include('Axioms/ITP001/ITP066^7.ax').
include('Axioms/ITP001/ITP067^7.ax').
include('Axioms/ITP001/ITP068^7.ax').
include('Axioms/ITP001/ITP069^7.ax').
include('Axioms/ITP001/ITP070^7.ax').
include('Axioms/ITP001/ITP071^7.ax').
include('Axioms/ITP001/ITP072^7.ax').
include('Axioms/ITP001/ITP073^7.ax').
include('Axioms/ITP001/ITP074^7.ax').
include('Axioms/ITP001/ITP075^7.ax').
include('Axioms/ITP001/ITP076^7.ax').
include('Axioms/ITP001/ITP077^7.ax').
include('Axioms/ITP001/ITP078^7.ax').
include('Axioms/ITP001/ITP079^7.ax').
include('Axioms/ITP001/ITP080^7.ax').
include('Axioms/ITP001/ITP081^7.ax').
include('Axioms/ITP001/ITP082^7.ax').
include('Axioms/ITP001/ITP083^7.ax').
include('Axioms/ITP001/ITP084^7.ax').
include('Axioms/ITP001/ITP085^7.ax').
include('Axioms/ITP001/ITP086^7.ax').
include('Axioms/ITP001/ITP087^7.ax').
include('Axioms/ITP001/ITP088^7.ax').
include('Axioms/ITP001/ITP089^7.ax').
include('Axioms/ITP001/ITP090^7.ax').
include('Axioms/ITP001/ITP091^7.ax').
include('Axioms/ITP001/ITP092^7.ax').
include('Axioms/ITP001/ITP093^7.ax').
include('Axioms/ITP001/ITP094^7.ax').
include('Axioms/ITP001/ITP095^7.ax').
include('Axioms/ITP001/ITP096^7.ax').
include('Axioms/ITP001/ITP097^7.ax').
include('Axioms/ITP001/ITP098^7.ax').
include('Axioms/ITP001/ITP099^7.ax').
include('Axioms/ITP001/ITP100^7.ax').
include('Axioms/ITP001/ITP101^7.ax').
include('Axioms/ITP001/ITP102^7.ax').
include('Axioms/ITP001/ITP103^7.ax').
include('Axioms/ITP001/ITP104^7.ax').
include('Axioms/ITP001/ITP105^7.ax').
include('Axioms/ITP001/ITP106^7.ax').
include('Axioms/ITP001/ITP107^7.ax').
include('Axioms/ITP001/ITP108^7.ax').
include('Axioms/ITP001/ITP109^7.ax').
include('Axioms/ITP001/ITP110^7.ax').
include('Axioms/ITP001/ITP111^7.ax').
include('Axioms/ITP001/ITP112^7.ax').
include('Axioms/ITP001/ITP113^7.ax').
include('Axioms/ITP001/ITP114^7.ax').
include('Axioms/ITP001/ITP116^7.ax').
include('Axioms/ITP001/ITP117^7.ax').
include('Axioms/ITP001/ITP118^7.ax').
include('Axioms/ITP001/ITP119^7.ax').
include('Axioms/ITP001/ITP120^7.ax').
include('Axioms/ITP001/ITP121^7.ax').
include('Axioms/ITP001/ITP123^7.ax').
include('Axioms/ITP001/ITP124^7.ax').
include('Axioms/ITP001/ITP126^7.ax').
include('Axioms/ITP001/ITP127^7.ax').
include('Axioms/ITP001/ITP128^7.ax').
include('Axioms/ITP001/ITP129^7.ax').
include('Axioms/ITP001/ITP130^7.ax').
include('Axioms/ITP001/ITP131^7.ax').
include('Axioms/ITP001/ITP132^7.ax').
include('Axioms/ITP001/ITP133^7.ax').
include('Axioms/ITP001/ITP134^7.ax').
include('Axioms/ITP001/ITP135^7.ax').
include('Axioms/ITP001/ITP136^7.ax').
include('Axioms/ITP001/ITP137^7.ax').
include('Axioms/ITP001/ITP138^7.ax').
include('Axioms/ITP001/ITP139^7.ax').
include('Axioms/ITP001/ITP140^7.ax').
include('Axioms/ITP001/ITP141^7.ax').
include('Axioms/ITP001/ITP142^7.ax').
%------------------------------------------------------------------------------
thf(tyop_2Eextreal_2Eextreal,type,
    tyop_2Eextreal_2Eextreal: $tType ).

thf(tyop_2Eind__type_2Erecspace,type,
    tyop_2Eind__type_2Erecspace: $tType > $tType ).

thf(tyop_2Emin_2Ebool,type,
    tyop_2Emin_2Ebool: $tType ).

thf(tyop_2Emin_2Efun,type,
    tyop_2Emin_2Efun: $tType > $tType > $tType ).

thf(tyop_2Enum_2Enum,type,
    tyop_2Enum_2Enum: $tType ).

thf(tyop_2Epair_2Eprod,type,
    tyop_2Epair_2Eprod: $tType > $tType > $tType ).

thf(tyop_2Erealax_2Ereal,type,
    tyop_2Erealax_2Ereal: $tType ).

thf(c_2Ebool_2E_21,type,
    c_2Ebool_2E_21: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Earithmetic_2E_2A,type,
    c_2Earithmetic_2E_2A: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2E_2B,type,
    c_2Earithmetic_2E_2B: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Epair_2E_2C,type,
    c_2Epair_2E_2C: 
      !>[A_27a: $tType,A_27b: $tType] : ( A_27a > A_27b > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) ) ).

thf(c_2Eseq_2E_2D_2D_3E,type,
    c_2Eseq_2E_2D_2D_3E: ( tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ) > tyop_2Erealax_2Ereal > $o ).

thf(c_2Ereal_2E_2F,type,
    c_2Ereal_2E_2F: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ebool_2E_2F_5C,type,
    c_2Ebool_2E_2F_5C: $o > $o > $o ).

thf(c_2Enum_2E0,type,
    c_2Enum_2E0: tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2E_3C_3D,type,
    c_2Earithmetic_2E_3C_3D: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Emin_2E_3D,type,
    c_2Emin_2E_3D: 
      !>[A_27a: $tType] : ( A_27a > A_27a > $o ) ).

thf(c_2Emin_2E_3D_3D_3E,type,
    c_2Emin_2E_3D_3D_3E: $o > $o > $o ).

thf(c_2Ebool_2E_3F,type,
    c_2Ebool_2E_3F: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Emin_2E_40,type,
    c_2Emin_2E_40: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > A_27a ) ).

thf(c_2Ebool_2EARB,type,
    c_2Ebool_2EARB: 
      !>[A_27a: $tType] : A_27a ).

thf(c_2Earithmetic_2EBIT1,type,
    c_2Earithmetic_2EBIT1: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Earithmetic_2EBIT2,type,
    c_2Earithmetic_2EBIT2: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Eind__type_2EBOTTOM,type,
    c_2Eind__type_2EBOTTOM: 
      !>[A_27a: $tType] : ( tyop_2Eind__type_2Erecspace @ A_27a ) ).

thf(c_2Epred__set_2ECARD,type,
    c_2Epred__set_2ECARD: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > tyop_2Enum_2Enum ) ).

thf(c_2Ebool_2ECOND,type,
    c_2Ebool_2ECOND: 
      !>[A_27a: $tType] : ( $o > A_27a > A_27a > A_27a ) ).

thf(c_2Eind__type_2ECONSTR,type,
    c_2Eind__type_2ECONSTR: 
      !>[A_27a: $tType] : ( tyop_2Enum_2Enum > A_27a > ( tyop_2Enum_2Enum > ( tyop_2Eind__type_2Erecspace @ A_27a ) ) > ( tyop_2Eind__type_2Erecspace @ A_27a ) ) ).

thf(c_2Epred__set_2ECROSS,type,
    c_2Epred__set_2ECROSS: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > $o ) > ( A_27b > $o ) > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > $o ) ).

thf(c_2Ebool_2EDATATYPE,type,
    c_2Ebool_2EDATATYPE: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Epred__set_2EDELETE,type,
    c_2Epred__set_2EDELETE: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > A_27a > A_27a > $o ) ).

thf(c_2Epred__set_2EDIFF,type,
    c_2Epred__set_2EDIFF: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Epred__set_2EDISJOINT,type,
    c_2Epred__set_2EDISJOINT: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( A_27a > $o ) > $o ) ).

thf(c_2Epred__set_2EEMPTY,type,
    c_2Epred__set_2EEMPTY: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Earithmetic_2EEVEN,type,
    c_2Earithmetic_2EEVEN: tyop_2Enum_2Enum > $o ).

thf(c_2Eextreal_2EEXTREAL__SUM__IMAGE,type,
    c_2Eextreal_2EEXTREAL__SUM__IMAGE: 
      !>[A_27a: $tType] : ( ( A_27a > tyop_2Eextreal_2Eextreal ) > ( A_27a > $o ) > tyop_2Eextreal_2Eextreal ) ).

thf(c_2Ebool_2EF,type,
    c_2Ebool_2EF: $o ).

thf(c_2Epred__set_2EFINITE,type,
    c_2Epred__set_2EFINITE: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > $o ) ).

thf(c_2Epair_2EFST,type,
    c_2Epair_2EFST: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27a ) ).

thf(c_2Ecombin_2EI,type,
    c_2Ecombin_2EI: 
      !>[A_27a: $tType] : ( A_27a > A_27a ) ).

thf(c_2Epred__set_2EIMAGE,type,
    c_2Epred__set_2EIMAGE: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27b ) > ( A_27a > $o ) > A_27b > $o ) ).

thf(c_2Ebool_2EIN,type,
    c_2Ebool_2EIN: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > $o ) ).

thf(c_2Epred__set_2EINJ,type,
    c_2Epred__set_2EINJ: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27b ) > ( A_27a > $o ) > ( A_27b > $o ) > $o ) ).

thf(c_2Epred__set_2EINSERT,type,
    c_2Epred__set_2EINSERT: 
      !>[A_27a: $tType] : ( A_27a > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Epred__set_2EINTER,type,
    c_2Epred__set_2EINTER: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Epred__set_2EITSET,type,
    c_2Epred__set_2EITSET: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27b > A_27b ) > ( A_27a > $o ) > A_27b > A_27b ) ).

thf(c_2Earithmetic_2ENUMERAL,type,
    c_2Earithmetic_2ENUMERAL: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Eextreal_2ENegInf,type,
    c_2Eextreal_2ENegInf: tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2ENormal,type,
    c_2Eextreal_2ENormal: tyop_2Erealax_2Ereal > tyop_2Eextreal_2Eextreal ).

thf(c_2Earithmetic_2EODD,type,
    c_2Earithmetic_2EODD: tyop_2Enum_2Enum > $o ).

thf(c_2Eextreal_2EPosInf,type,
    c_2Eextreal_2EPosInf: tyop_2Eextreal_2Eextreal ).

thf(c_2Ereal__sigma_2EREAL__SUM__IMAGE,type,
    c_2Ereal__sigma_2EREAL__SUM__IMAGE: 
      !>[A_27a: $tType] : ( ( A_27a > tyop_2Erealax_2Ereal ) > ( A_27a > $o ) > tyop_2Erealax_2Ereal ) ).

thf(c_2Epair_2ESND,type,
    c_2Epair_2ESND: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27b ) ).

thf(c_2Epred__set_2ESUBSET,type,
    c_2Epred__set_2ESUBSET: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( A_27a > $o ) > $o ) ).

thf(c_2Enum_2ESUC,type,
    c_2Enum_2ESUC: tyop_2Enum_2Enum > tyop_2Enum_2Enum ).

thf(c_2Ebool_2ET,type,
    c_2Ebool_2ET: $o ).

thf(c_2Ebool_2ETYPE__DEFINITION,type,
    c_2Ebool_2ETYPE__DEFINITION: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > $o ) > ( A_27b > A_27a ) > $o ) ).

thf(c_2Epair_2EUNCURRY,type,
    c_2Epair_2EUNCURRY: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( A_27a > A_27b > A_27c ) > ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > A_27c ) ).

thf(c_2Epred__set_2EUNION,type,
    c_2Epred__set_2EUNION: 
      !>[A_27a: $tType] : ( ( A_27a > $o ) > ( A_27a > $o ) > A_27a > $o ) ).

thf(c_2Epred__set_2EUNIV,type,
    c_2Epred__set_2EUNIV: 
      !>[A_27a: $tType] : ( A_27a > $o ) ).

thf(c_2Erelation_2EWF,type,
    c_2Erelation_2EWF: 
      !>[A_27a: $tType] : ( ( A_27a > A_27a > $o ) > $o ) ).

thf(c_2Erelation_2EWFREC,type,
    c_2Erelation_2EWFREC: 
      !>[A_27a: $tType,A_27b: $tType] : ( ( A_27a > A_27a > $o ) > ( ( A_27a > A_27b ) > A_27a > A_27b ) > A_27a > A_27b ) ).

thf(c_2Earithmetic_2EZERO,type,
    c_2Earithmetic_2EZERO: tyop_2Enum_2Enum ).

thf(c_2Ebool_2E_5C_2F,type,
    c_2Ebool_2E_5C_2F: $o > $o > $o ).

thf(c_2Ereal_2Eabs,type,
    c_2Ereal_2Eabs: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Epred__set_2Ecount,type,
    c_2Epred__set_2Ecount: tyop_2Enum_2Enum > tyop_2Enum_2Enum > $o ).

thf(c_2Etransc_2Eexp,type,
    c_2Etransc_2Eexp: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Eextreal_2Eext__mono__decreasing,type,
    c_2Eextreal_2Eext__mono__decreasing: ( tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal ) > $o ).

thf(c_2Eextreal_2Eext__mono__increasing,type,
    c_2Eextreal_2Eext__mono__increasing: ( tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal ) > $o ).

thf(c_2Eextreal_2Eext__suminf,type,
    c_2Eextreal_2Eext__suminf: ( tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal ) > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__CASE,type,
    c_2Eextreal_2Eextreal__CASE: 
      !>[A_27a: $tType] : ( tyop_2Eextreal_2Eextreal > A_27a > A_27a > ( tyop_2Erealax_2Ereal > A_27a ) > A_27a ) ).

thf(c_2Eextreal_2Eextreal__abs,type,
    c_2Eextreal_2Eextreal__abs: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__add,type,
    c_2Eextreal_2Eextreal__add: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__ainv,type,
    c_2Eextreal_2Eextreal__ainv: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__div,type,
    c_2Eextreal_2Eextreal__div: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__exp,type,
    c_2Eextreal_2Eextreal__exp: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__inf,type,
    c_2Eextreal_2Eextreal__inf: ( tyop_2Eextreal_2Eextreal > $o ) > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__inv,type,
    c_2Eextreal_2Eextreal__inv: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__le,type,
    c_2Eextreal_2Eextreal__le: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o ).

thf(c_2Eextreal_2Eextreal__lg,type,
    c_2Eextreal_2Eextreal__lg: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__logr,type,
    c_2Eextreal_2Eextreal__logr: tyop_2Erealax_2Ereal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__lt,type,
    c_2Eextreal_2Eextreal__lt: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o ).

thf(c_2Eextreal_2Eextreal__max,type,
    c_2Eextreal_2Eextreal__max: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__min,type,
    c_2Eextreal_2Eextreal__min: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__mul,type,
    c_2Eextreal_2Eextreal__mul: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__of__num,type,
    c_2Eextreal_2Eextreal__of__num: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__pow,type,
    c_2Eextreal_2Eextreal__pow: tyop_2Eextreal_2Eextreal > tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__size,type,
    c_2Eextreal_2Eextreal__size: tyop_2Eextreal_2Eextreal > tyop_2Enum_2Enum ).

thf(c_2Eextreal_2Eextreal__sqrt,type,
    c_2Eextreal_2Eextreal__sqrt: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__sub,type,
    c_2Eextreal_2Eextreal__sub: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal ).

thf(c_2Eextreal_2Eextreal__sup,type,
    c_2Eextreal_2Eextreal__sup: ( tyop_2Eextreal_2Eextreal > $o ) > tyop_2Eextreal_2Eextreal ).

thf(c_2Erealax_2Einv,type,
    c_2Erealax_2Einv: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Eutil__prob_2Elogr,type,
    c_2Eutil__prob_2Elogr: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Eextreal_2Emono__decreasing,type,
    c_2Eextreal_2Emono__decreasing: ( tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ) > $o ).

thf(c_2Eextreal_2Emono__increasing,type,
    c_2Eextreal_2Emono__increasing: ( tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ) > $o ).

thf(c_2Ecombin_2Eo,type,
    c_2Ecombin_2Eo: 
      !>[A_27a: $tType,A_27b: $tType,A_27c: $tType] : ( ( A_27c > A_27b ) > ( A_27a > A_27c ) > A_27a > A_27b ) ).

thf(c_2Ereal_2Epow,type,
    c_2Ereal_2Epow: tyop_2Erealax_2Ereal > tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ).

thf(c_2Eextreal_2Ereal,type,
    c_2Eextreal_2Ereal: tyop_2Eextreal_2Eextreal > tyop_2Erealax_2Ereal ).

thf(c_2Erealax_2Ereal__add,type,
    c_2Erealax_2Ereal__add: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Erealax_2Ereal__lt,type,
    c_2Erealax_2Ereal__lt: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Ereal_2Ereal__lte,type,
    c_2Ereal_2Ereal__lte: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > $o ).

thf(c_2Erealax_2Ereal__mul,type,
    c_2Erealax_2Ereal__mul: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Erealax_2Ereal__neg,type,
    c_2Erealax_2Ereal__neg: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Ereal__of__num,type,
    c_2Ereal_2Ereal__of__num: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Ereal__sub,type,
    c_2Ereal_2Ereal__sub: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Etransc_2Esqrt,type,
    c_2Etransc_2Esqrt: tyop_2Erealax_2Ereal > tyop_2Erealax_2Ereal ).

thf(c_2Eseq_2Esuminf,type,
    c_2Eseq_2Esuminf: ( tyop_2Enum_2Enum > tyop_2Erealax_2Ereal ) > tyop_2Erealax_2Ereal ).

thf(c_2Ereal_2Esup,type,
    c_2Ereal_2Esup: ( tyop_2Erealax_2Ereal > $o ) > tyop_2Erealax_2Ereal ).

thf(c_2Ebool_2E_7E,type,
    c_2Ebool_2E_7E: $o > $o ).

thf(logicdef_2E_2F_5C,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_2F_5C @ V0 @ V1 )
    <=> ( V0
        & V1 ) ) ).

thf(logicdef_2E_5C_2F,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Ebool_2E_5C_2F @ V0 @ V1 )
    <=> ( V0
        | V1 ) ) ).

thf(logicdef_2E_7E,axiom,
    ! [V0: $o] :
      ( ( c_2Ebool_2E_7E @ V0 )
    <=> ( (~) @ V0 ) ) ).

thf(logicdef_2E_3D_3D_3E,axiom,
    ! [V0: $o,V1: $o] :
      ( ( c_2Emin_2E_3D_3D_3E @ V0 @ V1 )
    <=> ( V0
       => V1 ) ) ).

thf(logicdef_2E_3D,axiom,
    ! [A_27a: $tType,V0: A_27a,V1: A_27a] :
      ( ( c_2Emin_2E_3D @ A_27a @ V0 @ V1 )
    <=> ( V0 = V1 ) ) ).

thf(quantdef_2E_21,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_21 @ A_27a @ V0f )
    <=> ! [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(quantdef_2E_3F,axiom,
    ! [A_27a: $tType,V0f: A_27a > $o] :
      ( ( c_2Ebool_2E_3F @ A_27a @ V0f )
    <=> ? [V1x: A_27a] : ( V0f @ V1x ) ) ).

thf(thm_2Eextreal_2Emono__decreasing__def,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__decreasing @ V0f )
    <=> ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Ereal_2Ereal__lte @ ( V0f @ V2n ) @ ( V0f @ V1m ) ) ) ) ).

thf(thm_2Eextreal_2Emono__increasing__def,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__increasing @ V0f )
    <=> ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Ereal_2Ereal__lte @ ( V0f @ V1m ) @ ( V0f @ V2n ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__sqrt__def,axiom,
    ( ! [V0x: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__sqrt @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Etransc_2Esqrt @ V0x ) ) )
    & ( ( c_2Eextreal_2Eextreal__sqrt @ c_2Eextreal_2EPosInf )
      = c_2Eextreal_2EPosInf ) ) ).

thf(thm_2Eextreal_2Eextreal__pow__def,axiom,
    ( ! [V0a: tyop_2Erealax_2Ereal,V1n: tyop_2Enum_2Enum] :
        ( ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2ENormal @ V0a ) @ V1n )
        = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Epow @ V0a @ V1n ) ) )
    & ! [V2n: tyop_2Enum_2Enum] :
        ( ( c_2Eextreal_2Eextreal__pow @ c_2Eextreal_2EPosInf @ V2n )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V2n @ c_2Enum_2E0 ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ c_2Eextreal_2EPosInf ) )
    & ! [V3n: tyop_2Enum_2Enum] :
        ( ( c_2Eextreal_2Eextreal__pow @ c_2Eextreal_2ENegInf @ V3n )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Enum_2Enum @ V3n @ c_2Enum_2E0 ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Earithmetic_2EEVEN @ V3n ) @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__exp__def,axiom,
    ( ! [V0x: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__exp @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Etransc_2Eexp @ V0x ) ) )
    & ( ( c_2Eextreal_2Eextreal__exp @ c_2Eextreal_2EPosInf )
      = c_2Eextreal_2EPosInf )
    & ( ( c_2Eextreal_2Eextreal__exp @ c_2Eextreal_2ENegInf )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__lg__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lg @ V0x )
      = ( c_2Eextreal_2Eextreal__logr @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0x ) ) ).

thf(thm_2Eextreal_2Eextreal__logr__def,axiom,
    ( ! [V0b: tyop_2Erealax_2Ereal,V1x: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__logr @ V0b @ ( c_2Eextreal_2ENormal @ V1x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Eutil__prob_2Elogr @ V0b @ V1x ) ) )
    & ! [V2b: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__logr @ V2b @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2EPosInf )
    & ! [V3b: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__logr @ V3b @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2ENegInf ) ) ).

thf(thm_2Eextreal_2Eextreal__abs__primitive__def,axiom,
    ( c_2Eextreal_2Eextreal__abs
    = ( c_2Erelation_2EWFREC @ tyop_2Eextreal_2Eextreal @ tyop_2Eextreal_2Eextreal
      @ ( c_2Emin_2E_40 @ ( tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o )
        @ ^ [V0R: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o] : ( c_2Erelation_2EWF @ tyop_2Eextreal_2Eextreal @ V0R ) )
      @ ^ [V1extreal__abs: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal,V2a: tyop_2Eextreal_2Eextreal] :
          ( c_2Eextreal_2Eextreal__CASE @ tyop_2Eextreal_2Eextreal @ V2a @ ( c_2Ecombin_2EI @ tyop_2Eextreal_2Eextreal @ c_2Eextreal_2EPosInf ) @ ( c_2Ecombin_2EI @ tyop_2Eextreal_2Eextreal @ c_2Eextreal_2EPosInf )
          @ ^ [V3x: tyop_2Erealax_2Ereal] : ( c_2Ecombin_2EI @ tyop_2Eextreal_2Eextreal @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Eabs @ V3x ) ) ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__div__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__div @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__inv @ V1y ) ) ) ).

thf(thm_2Eextreal_2Eextreal__ainv__def,axiom,
    ( ( ( c_2Eextreal_2Eextreal__ainv @ c_2Eextreal_2ENegInf )
      = c_2Eextreal_2EPosInf )
    & ( ( c_2Eextreal_2Eextreal__ainv @ c_2Eextreal_2EPosInf )
      = c_2Eextreal_2ENegInf )
    & ! [V0x: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Erealax_2Ereal__neg @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__inv__def,axiom,
    ( ( ( c_2Eextreal_2Eextreal__inv @ c_2Eextreal_2ENegInf )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
    & ( ( c_2Eextreal_2Eextreal__inv @ c_2Eextreal_2EPosInf )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
    & ! [V0x: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__inv @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Erealax_2Einv @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__lt__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
    <=> ( (~) @ ( c_2Eextreal_2Eextreal__le @ V1y @ V0x ) ) ) ).

thf(thm_2Eextreal_2Ereal__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Ereal @ V0x )
      = ( c_2Ebool_2ECOND @ tyop_2Erealax_2Ereal @ ( c_2Ebool_2E_5C_2F @ ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V0x @ c_2Eextreal_2ENegInf ) @ ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V0x @ c_2Eextreal_2EPosInf ) ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 )
        @ ( c_2Emin_2E_40 @ tyop_2Erealax_2Ereal
          @ ^ [V1r: tyop_2Erealax_2Ereal] : ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V0x @ ( c_2Eextreal_2ENormal @ V1r ) ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__of__num__def,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Eextreal_2Eextreal__of__num @ V0n )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ V0n ) ) ) ).

thf(thm_2Eextreal_2Eextreal__TY__DEF,axiom,
    ? [V0rep: tyop_2Eextreal_2Eextreal > ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal )] :
      ( c_2Ebool_2ETYPE__DEFINITION @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ tyop_2Eextreal_2Eextreal
      @ ^ [V1a0: tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal] :
          ( c_2Ebool_2E_21 @ ( ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) > $o )
          @ ^ [V2_27extreal_27: ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) > $o] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal )
                @ ^ [V3a0: tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal] :
                    ( c_2Emin_2E_3D_3D_3E
                    @ ( c_2Ebool_2E_5C_2F
                      @ ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                        @ ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ c_2Enum_2E0 @ ( c_2Ebool_2EARB @ tyop_2Erealax_2Ereal )
                          @ ^ [V4n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) ) )
                      @ ( c_2Ebool_2E_5C_2F
                        @ ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                          @ ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) @ ( c_2Ebool_2EARB @ tyop_2Erealax_2Ereal )
                            @ ^ [V5n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) ) )
                        @ ( c_2Ebool_2E_3F @ tyop_2Erealax_2Ereal
                          @ ^ [V6a: tyop_2Erealax_2Ereal] :
                              ( c_2Emin_2E_3D @ ( tyop_2Eind__type_2Erecspace @ tyop_2Erealax_2Ereal ) @ V3a0
                              @ ( ^ [V7a: tyop_2Erealax_2Ereal] :
                                    ( c_2Eind__type_2ECONSTR @ tyop_2Erealax_2Ereal @ ( c_2Enum_2ESUC @ ( c_2Enum_2ESUC @ c_2Enum_2E0 ) ) @ V7a
                                    @ ^ [V8n: tyop_2Enum_2Enum] : ( c_2Eind__type_2EBOTTOM @ tyop_2Erealax_2Ereal ) )
                                @ V6a ) ) ) ) )
                    @ ( V2_27extreal_27 @ V3a0 ) ) )
              @ ( V2_27extreal_27 @ V1a0 ) ) )
      @ V0rep ) ).

thf(thm_2Eextreal_2Eextreal__case__def,axiom,
    ! [A_27a: $tType] :
      ( ! [V0v: A_27a,V1v1: A_27a,V2f: tyop_2Erealax_2Ereal > A_27a] :
          ( ( c_2Eextreal_2Eextreal__CASE @ A_27a @ c_2Eextreal_2ENegInf @ V0v @ V1v1 @ V2f )
          = V0v )
      & ! [V3v: A_27a,V4v1: A_27a,V5f: tyop_2Erealax_2Ereal > A_27a] :
          ( ( c_2Eextreal_2Eextreal__CASE @ A_27a @ c_2Eextreal_2EPosInf @ V3v @ V4v1 @ V5f )
          = V4v1 )
      & ! [V6a: tyop_2Erealax_2Ereal,V7v: A_27a,V8v1: A_27a,V9f: tyop_2Erealax_2Ereal > A_27a] :
          ( ( c_2Eextreal_2Eextreal__CASE @ A_27a @ ( c_2Eextreal_2ENormal @ V6a ) @ V7v @ V8v1 @ V9f )
          = ( V9f @ V6a ) ) ) ).

thf(thm_2Eextreal_2Eextreal__size__def,axiom,
    ( ( ( c_2Eextreal_2Eextreal__size @ c_2Eextreal_2ENegInf )
      = c_2Enum_2E0 )
    & ( ( c_2Eextreal_2Eextreal__size @ c_2Eextreal_2EPosInf )
      = c_2Enum_2E0 )
    & ! [V0a: tyop_2Erealax_2Ereal] :
        ( ( c_2Eextreal_2Eextreal__size @ ( c_2Eextreal_2ENormal @ V0a ) )
        = ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Eext__mono__increasing__def,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eext__mono__increasing @ V0f )
    <=> ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Eextreal_2Eextreal__le @ ( V0f @ V1m ) @ ( V0f @ V2n ) ) ) ) ).

thf(thm_2Eextreal_2Eext__mono__decreasing__def,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eext__mono__decreasing @ V0f )
    <=> ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Eextreal_2Eextreal__le @ ( V0f @ V2n ) @ ( V0f @ V1m ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__DEF,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
      = ( c_2Epred__set_2EITSET @ A_27a @ tyop_2Eextreal_2Eextreal
        @ ^ [V2e: A_27a,V3acc: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__add @ ( V0f @ V2e ) @ V3acc )
        @ V1s
        @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Eextreal__sup__def,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o] :
      ( ( c_2Eextreal_2Eextreal__sup @ V0p )
      = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal
        @ ( c_2Ebool_2E_21 @ tyop_2Eextreal_2Eextreal
          @ ^ [V1x: tyop_2Eextreal_2Eextreal] :
              ( c_2Emin_2E_3D_3D_3E
              @ ( c_2Ebool_2E_21 @ tyop_2Eextreal_2Eextreal
                @ ^ [V2y: tyop_2Eextreal_2Eextreal] : ( c_2Emin_2E_3D_3D_3E @ ( V0p @ V2y ) @ ( c_2Eextreal_2Eextreal__le @ V2y @ V1x ) ) )
              @ ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V1x @ c_2Eextreal_2EPosInf ) ) )
        @ c_2Eextreal_2EPosInf
        @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal
          @ ( c_2Ebool_2E_21 @ tyop_2Eextreal_2Eextreal
            @ ^ [V3x: tyop_2Eextreal_2Eextreal] : ( c_2Emin_2E_3D_3D_3E @ ( V0p @ V3x ) @ ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V3x @ c_2Eextreal_2ENegInf ) ) )
          @ c_2Eextreal_2ENegInf
          @ ( c_2Eextreal_2ENormal
            @ ( c_2Ereal_2Esup
              @ ^ [V4r: tyop_2Erealax_2Ereal] : ( V0p @ ( c_2Eextreal_2ENormal @ V4r ) ) ) ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__inf__def,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o] :
      ( ( c_2Eextreal_2Eextreal__inf @ V0p )
      = ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Eextreal_2Eextreal @ tyop_2Eextreal_2Eextreal @ c_2Eextreal_2Eextreal__ainv @ V0p ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__def,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eext__suminf @ V0f )
      = ( c_2Eextreal_2Eextreal__sup
        @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
          @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ V1n ) )
          @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__min__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__min @ V0x @ V1y )
      = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Eextreal__max__def,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__max @ V0x @ V1y )
      = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Enum__not__infty,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( (~)
        @ ( ( c_2Eextreal_2Eextreal__of__num @ V0n )
          = c_2Eextreal_2ENegInf ) )
      & ( (~)
        @ ( ( c_2Eextreal_2Eextreal__of__num @ V0n )
          = c_2Eextreal_2EPosInf ) ) ) ).

thf(thm_2Eextreal_2Eextreal__not__infty,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
      ( ( (~)
        @ ( ( c_2Eextreal_2ENormal @ V0x )
          = c_2Eextreal_2ENegInf ) )
      & ( (~)
        @ ( ( c_2Eextreal_2ENormal @ V0x )
          = c_2Eextreal_2EPosInf ) ) ) ).

thf(thm_2Eextreal_2Eextreal__eq__zero,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Eextreal_2ENormal @ V0x )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
    <=> ( V0x
        = ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Eextreal__cases,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( V0x = c_2Eextreal_2ENegInf )
      | ( V0x = c_2Eextreal_2EPosInf )
      | ? [V1r: tyop_2Erealax_2Ereal] :
          ( V0x
          = ( c_2Eextreal_2ENormal @ V1r ) ) ) ).

thf(thm_2Eextreal_2Emono__increasing__converges__to__sup,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal,V1r: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Eextreal_2Emono__increasing @ V0f )
        & ( c_2Eseq_2E_2D_2D_3E @ V0f @ V1r ) )
     => ( V1r
        = ( c_2Ereal_2Esup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Erealax_2Ereal @ V0f @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ) ).

thf(thm_2Eextreal_2Emono__decreasing__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__decreasing @ V0f )
    <=> ! [V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( V0f @ ( c_2Enum_2ESUC @ V1n ) ) @ ( V0f @ V1n ) ) ) ).

thf(thm_2Eextreal_2Emono__increasing__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__increasing @ V0f )
    <=> ! [V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( V0f @ V1n ) @ ( V0f @ ( c_2Enum_2ESUC @ V1n ) ) ) ) ).

thf(thm_2Eextreal_2ELOGR__MONO__LE__IMP,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal,V2b: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Ereal_2Ereal__lte @ V0x @ V1y )
        & ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2b ) )
     => ( c_2Ereal_2Ereal__lte @ ( c_2Eutil__prob_2Elogr @ V2b @ V0x ) @ ( c_2Eutil__prob_2Elogr @ V2b @ V1y ) ) ) ).

thf(thm_2Eextreal_2ELOGR__MONO__LE,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal,V2b: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1y )
        & ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V2b ) )
     => ( ( c_2Ereal_2Ereal__lte @ ( c_2Eutil__prob_2Elogr @ V2b @ V0x ) @ ( c_2Eutil__prob_2Elogr @ V2b @ V1y ) )
        = ( c_2Ereal_2Ereal__lte @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2EPOW__NEG__ODD,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Epow @ V1x @ V0n ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        = ( c_2Earithmetic_2EODD @ V0n ) ) ) ).

thf(thm_2Eextreal_2EPOW__POS__EVEN,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ V1x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Ereal_2Epow @ V1x @ V0n ) )
        = ( c_2Earithmetic_2EEVEN @ V0n ) ) ) ).

thf(thm_2Eextreal_2EREAL__LE__RDIV__EQ__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal,V2z: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ V2z @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2E_2F @ V1y @ V2z ) @ V0x )
        = ( c_2Ereal_2Ereal__lte @ ( c_2Erealax_2Ereal__mul @ V0x @ V2z ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2EREAL__LT__RDIV__EQ__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal,V2z: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ V2z @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2E_2F @ V1y @ V2z ) @ V0x )
        = ( c_2Erealax_2Ereal__lt @ ( c_2Erealax_2Ereal__mul @ V0x @ V2z ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2EREAL__LT__RMUL__NEG__0__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Erealax_2Ereal__lt @ V1y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Eextreal_2EREAL__LT__LMUL__NEG__0__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Erealax_2Ereal__lt @ V0x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1y ) ) ).

thf(thm_2Eextreal_2EREAL__LT__RMUL__NEG__0,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Erealax_2Ereal__lt @ V0x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2EREAL__LT__LMUL__NEG__0,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x ) )
     => ( c_2Erealax_2Ereal__lt @ V1y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2EREAL__LT__RMUL__0__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) )
        & ( c_2Erealax_2Ereal__lt @ V1y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Erealax_2Ereal__lt @ V0x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2EREAL__LT__LMUL__0__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( c_2Erealax_2Ereal__mul @ V0x @ V1y ) )
        & ( c_2Erealax_2Ereal__lt @ V0x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Erealax_2Ereal__lt @ V1y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Eextreal__abs__def,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Eextreal_2Eextreal__abs @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Eabs @ V0x ) ) )
      & ( ( c_2Eextreal_2Eextreal__abs @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__abs @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2EPosInf ) ) ).

thf(thm_2Eextreal_2Eextreal__abs__ind,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > $o] :
      ( ( ! [V1x: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1x ) )
        & ( V0P @ c_2Eextreal_2ENegInf )
        & ( V0P @ c_2Eextreal_2EPosInf ) )
     => ! [V2v: tyop_2Eextreal_2Eextreal] : ( V0P @ V2v ) ) ).

thf(thm_2Eextreal_2Eextreal__mul__def,axiom,
    ! [V0y: tyop_2Erealax_2Ereal,V1x: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2EPosInf @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1x ) @ c_2Eextreal_2ENegInf )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V1x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1x ) @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf ) ) )
      & ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V0y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0y ) @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf ) ) )
      & ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1x ) @ c_2Eextreal_2EPosInf )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V1x @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1x ) @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf ) ) )
      & ( ( c_2Eextreal_2Eextreal__mul @ c_2Eextreal_2EPosInf @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Emin_2E_3D @ tyop_2Erealax_2Ereal @ V0y @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) ) @ ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0y ) @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf ) ) )
      & ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Erealax_2Ereal__mul @ V1x @ V0y ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__mul__ind,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o] :
      ( ( ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        & ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        & ( V0P @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf )
        & ( V0P @ c_2Eextreal_2EPosInf @ c_2Eextreal_2EPosInf )
        & ! [V1x: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1x ) @ c_2Eextreal_2ENegInf )
        & ! [V2y: tyop_2Erealax_2Ereal] : ( V0P @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V2y ) )
        & ! [V3x: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V3x ) @ c_2Eextreal_2EPosInf )
        & ! [V4y: tyop_2Erealax_2Ereal] : ( V0P @ c_2Eextreal_2EPosInf @ ( c_2Eextreal_2ENormal @ V4y ) )
        & ! [V5x: tyop_2Erealax_2Ereal,V6y: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V5x ) @ ( c_2Eextreal_2ENormal @ V6y ) ) )
     => ! [V7v: tyop_2Eextreal_2Eextreal,V8v1: tyop_2Eextreal_2Eextreal] : ( V0P @ V7v @ V8v1 ) ) ).

thf(thm_2Eextreal_2Eextreal__le__def,axiom,
    ! [V0y: tyop_2Erealax_2Ereal,V1x: tyop_2Erealax_2Ereal,V2v5: tyop_2Erealax_2Ereal,V3v3: tyop_2Erealax_2Ereal,V4v2: tyop_2Erealax_2Ereal,V5a: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Ereal_2Ereal__lte @ V1x @ V0y ) )
      & ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2ENegInf @ V5a )
        = c_2Ebool_2ET )
      & ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2EPosInf @ c_2Eextreal_2EPosInf )
        = c_2Ebool_2ET )
      & ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        = c_2Ebool_2ET )
      & ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf )
        = c_2Ebool_2EF )
      & ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2ENormal @ V3v3 ) @ c_2Eextreal_2ENegInf )
        = c_2Ebool_2EF )
      & ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2EPosInf @ ( c_2Eextreal_2ENormal @ V2v5 ) )
        = c_2Ebool_2EF ) ) ).

thf(thm_2Eextreal_2Eextreal__le__ind,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o] :
      ( ( ! [V1x: tyop_2Erealax_2Ereal,V2y: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V2y ) )
        & ! [V3a: tyop_2Eextreal_2Eextreal] : ( V0P @ c_2Eextreal_2ENegInf @ V3a )
        & ( V0P @ c_2Eextreal_2EPosInf @ c_2Eextreal_2EPosInf )
        & ! [V4v2: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        & ( V0P @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENegInf )
        & ! [V5v3: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V5v3 ) @ c_2Eextreal_2ENegInf )
        & ! [V6v5: tyop_2Erealax_2Ereal] : ( V0P @ c_2Eextreal_2EPosInf @ ( c_2Eextreal_2ENormal @ V6v5 ) ) )
     => ! [V7v: tyop_2Eextreal_2Eextreal,V8v1: tyop_2Eextreal_2Eextreal] : ( V0P @ V7v @ V8v1 ) ) ).

thf(thm_2Eextreal_2Eextreal__sub__def,axiom,
    ! [V0y: tyop_2Erealax_2Ereal,V1x: tyop_2Erealax_2Ereal,V2v5: tyop_2Erealax_2Ereal,V3v3: tyop_2Erealax_2Ereal,V4v2: tyop_2Erealax_2Ereal,V5a: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Ereal__sub @ V1x @ V0y ) ) )
      & ( ( c_2Eextreal_2Eextreal__sub @ c_2Eextreal_2EPosInf @ V5a )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__sub @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__sub @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__sub @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V2v5 ) )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V3v3 ) @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2EPosInf ) ) ).

thf(thm_2Eextreal_2Eextreal__sub__ind,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o] :
      ( ( ! [V1x: tyop_2Erealax_2Ereal,V2y: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V2y ) )
        & ! [V3a: tyop_2Eextreal_2Eextreal] : ( V0P @ c_2Eextreal_2EPosInf @ V3a )
        & ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        & ! [V4v2: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        & ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        & ! [V5v5: tyop_2Erealax_2Ereal] : ( V0P @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V5v5 ) )
        & ! [V6v3: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V6v3 ) @ c_2Eextreal_2ENegInf ) )
     => ! [V7v: tyop_2Eextreal_2Eextreal,V8v1: tyop_2Eextreal_2Eextreal] : ( V0P @ V7v @ V8v1 ) ) ).

thf(thm_2Eextreal_2Eextreal__add__def,axiom,
    ! [V0y: tyop_2Erealax_2Ereal,V1x: tyop_2Erealax_2Ereal,V2v5: tyop_2Erealax_2Ereal,V3v3: tyop_2Erealax_2Ereal,V4v2: tyop_2Erealax_2Ereal,V5a: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V0y ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Erealax_2Ereal__add @ V1x @ V0y ) ) )
      & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2EPosInf @ V5a )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        = c_2Eextreal_2EPosInf )
      & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V2v5 ) )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2ENormal @ V3v3 ) @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2ENegInf ) ) ).

thf(thm_2Eextreal_2Eextreal__add__ind,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > $o] :
      ( ( ! [V1x: tyop_2Erealax_2Ereal,V2y: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1x ) @ ( c_2Eextreal_2ENormal @ V2y ) )
        & ! [V3a: tyop_2Eextreal_2Eextreal] : ( V0P @ c_2Eextreal_2EPosInf @ V3a )
        & ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
        & ! [V4v2: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V4v2 ) @ c_2Eextreal_2EPosInf )
        & ( V0P @ c_2Eextreal_2ENegInf @ c_2Eextreal_2ENegInf )
        & ! [V5v5: tyop_2Erealax_2Ereal] : ( V0P @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V5v5 ) )
        & ! [V6v3: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V6v3 ) @ c_2Eextreal_2ENegInf ) )
     => ! [V7v: tyop_2Eextreal_2Eextreal,V8v1: tyop_2Eextreal_2Eextreal] : ( V0P @ V7v @ V8v1 ) ) ).

thf(thm_2Eextreal_2Enormal__real,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2ENormal @ ( c_2Eextreal_2Ereal @ V0x ) )
        = V0x ) ) ).

thf(thm_2Eextreal_2Ereal__normal,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Ereal @ ( c_2Eextreal_2ENormal @ V0x ) )
      = V0x ) ).

thf(thm_2Eextreal_2Eextreal__case__eq,axiom,
    ! [A_27a: $tType,V0x: tyop_2Eextreal_2Eextreal,V1v1: A_27a,V2v_27: A_27a,V3v: A_27a,V4f: tyop_2Erealax_2Ereal > A_27a] :
      ( ( ( c_2Eextreal_2Eextreal__CASE @ A_27a @ V0x @ V3v @ V1v1 @ V4f )
        = V2v_27 )
    <=> ( ( ( V0x = c_2Eextreal_2ENegInf )
          & ( V3v = V2v_27 ) )
        | ( ( V0x = c_2Eextreal_2EPosInf )
          & ( V1v1 = V2v_27 ) )
        | ? [V5r: tyop_2Erealax_2Ereal] :
            ( ( V0x
              = ( c_2Eextreal_2ENormal @ V5r ) )
            & ( ( V4f @ V5r )
              = V2v_27 ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__case__cong,axiom,
    ! [A_27a: $tType,V0v1_27: A_27a,V1v_27: A_27a,V2f_27: tyop_2Erealax_2Ereal > A_27a,V3M: tyop_2Eextreal_2Eextreal,V4M_27: tyop_2Eextreal_2Eextreal,V5v: A_27a,V6v1: A_27a,V7f: tyop_2Erealax_2Ereal > A_27a] :
      ( ( ( V3M = V4M_27 )
        & ( ( V4M_27 = c_2Eextreal_2ENegInf )
         => ( V5v = V1v_27 ) )
        & ( ( V4M_27 = c_2Eextreal_2EPosInf )
         => ( V6v1 = V0v1_27 ) )
        & ! [V8a: tyop_2Erealax_2Ereal] :
            ( ( V4M_27
              = ( c_2Eextreal_2ENormal @ V8a ) )
           => ( ( V7f @ V8a )
              = ( V2f_27 @ V8a ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__CASE @ A_27a @ V3M @ V5v @ V6v1 @ V7f )
        = ( c_2Eextreal_2Eextreal__CASE @ A_27a @ V4M_27 @ V1v_27 @ V0v1_27 @ V2f_27 ) ) ) ).

thf(thm_2Eextreal_2Eextreal__induction,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > $o] :
      ( ( ( V0P @ c_2Eextreal_2ENegInf )
        & ( V0P @ c_2Eextreal_2EPosInf )
        & ! [V1r: tyop_2Erealax_2Ereal] : ( V0P @ ( c_2Eextreal_2ENormal @ V1r ) ) )
     => ! [V2e: tyop_2Eextreal_2Eextreal] : ( V0P @ V2e ) ) ).

thf(thm_2Eextreal_2Eextreal__Axiom,axiom,
    ! [A_27a: $tType,V0f0: A_27a,V1f1: A_27a,V2f2: tyop_2Erealax_2Ereal > A_27a] :
    ? [V3fn: tyop_2Eextreal_2Eextreal > A_27a] :
      ( ( ( V3fn @ c_2Eextreal_2ENegInf )
        = V0f0 )
      & ( ( V3fn @ c_2Eextreal_2EPosInf )
        = V1f1 )
      & ! [V4a: tyop_2Erealax_2Ereal] :
          ( ( V3fn @ ( c_2Eextreal_2ENormal @ V4a ) )
          = ( V2f2 @ V4a ) ) ) ).

thf(thm_2Eextreal_2Eextreal__nchotomy,axiom,
    ! [V0ee: tyop_2Eextreal_2Eextreal] :
      ( ( V0ee = c_2Eextreal_2ENegInf )
      | ( V0ee = c_2Eextreal_2EPosInf )
      | ? [V1r: tyop_2Erealax_2Ereal] :
          ( V0ee
          = ( c_2Eextreal_2ENormal @ V1r ) ) ) ).

thf(thm_2Eextreal_2Eextreal__distinct,axiom,
    ( ( (~) @ ( c_2Eextreal_2ENegInf = c_2Eextreal_2EPosInf ) )
    & ! [V0a: tyop_2Erealax_2Ereal] :
        ( (~)
        @ ( c_2Eextreal_2ENegInf
          = ( c_2Eextreal_2ENormal @ V0a ) ) )
    & ! [V1a: tyop_2Erealax_2Ereal] :
        ( (~)
        @ ( c_2Eextreal_2EPosInf
          = ( c_2Eextreal_2ENormal @ V1a ) ) ) ) ).

thf(thm_2Eextreal_2Edatatype__extreal,axiom,
    ! [V0extreal: tyop_2Eextreal_2Eextreal > tyop_2Eextreal_2Eextreal > ( tyop_2Erealax_2Ereal > tyop_2Eextreal_2Eextreal ) > $o] : ( c_2Ebool_2EDATATYPE @ $o @ ( V0extreal @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf @ c_2Eextreal_2ENormal ) ) ).

thf(thm_2Eextreal_2Eextreal__11,axiom,
    ! [V0a: tyop_2Erealax_2Ereal,V1a_27: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Eextreal_2ENormal @ V0a )
        = ( c_2Eextreal_2ENormal @ V1a_27 ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(thm_2Eextreal_2Emul__rzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
      = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Eextreal_2Emul__lzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
      = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Eextreal_2Emul__rone,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = V0x ) ).

thf(thm_2Eextreal_2Emul__lone,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x )
      = V0x ) ).

thf(thm_2Eextreal_2Eentire,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
    <=> ( ( V0x
          = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
        | ( V1y
          = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__lt__eq,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2ENormal @ V0x ) @ ( c_2Eextreal_2ENormal @ V1y ) )
      = ( c_2Erealax_2Ereal__lt @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Ele__refl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ V0x @ V0x ) ).

thf(thm_2Eextreal_2Elt__refl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] : ( (~) @ ( c_2Eextreal_2Eextreal__lt @ V0x @ V0x ) ) ).

thf(thm_2Eextreal_2Ele__infty,axiom,
    ( ! [V0x: tyop_2Eextreal_2Eextreal] :
        ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2ENegInf @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ V0x @ c_2Eextreal_2EPosInf ) )
    & ! [V1x: tyop_2Eextreal_2Eextreal] :
        ( ( c_2Eextreal_2Eextreal__le @ V1x @ c_2Eextreal_2ENegInf )
      <=> ( V1x = c_2Eextreal_2ENegInf ) )
    & ! [V2x: tyop_2Eextreal_2Eextreal] :
        ( ( c_2Eextreal_2Eextreal__le @ c_2Eextreal_2EPosInf @ V2x )
      <=> ( V2x = c_2Eextreal_2EPosInf ) ) ) ).

thf(thm_2Eextreal_2Elt__infty,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2ENormal @ V1y ) )
      & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2ENormal @ V1y ) @ c_2Eextreal_2EPosInf )
      & ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2ENegInf @ c_2Eextreal_2EPosInf )
      & ( (~) @ ( c_2Eextreal_2Eextreal__lt @ V0x @ c_2Eextreal_2ENegInf ) )
      & ( (~) @ ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2EPosInf @ V0x ) )
      & ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
      <=> ( c_2Eextreal_2Eextreal__lt @ V0x @ c_2Eextreal_2EPosInf ) )
      & ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
      <=> ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2ENegInf @ V0x ) ) ) ).

thf(thm_2Eextreal_2Elt__imp__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
     => ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Elt__imp__ne,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
     => ( (~) @ ( V0x = V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__trans,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ V2z ) )
     => ( c_2Eextreal_2Eextreal__le @ V0x @ V2z ) ) ).

thf(thm_2Eextreal_2Elt__trans,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ V2z ) )
     => ( c_2Eextreal_2Eextreal__lt @ V0x @ V2z ) ) ).

thf(thm_2Eextreal_2Elet__trans,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ V2z ) )
     => ( c_2Eextreal_2Eextreal__lt @ V0x @ V2z ) ) ).

thf(thm_2Eextreal_2Ele__antisym,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ V0x ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Eextreal_2Elt__antisym,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( (~)
      @ ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ V0x ) ) ) ).

thf(thm_2Eextreal_2Elte__trans,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ V2z ) )
     => ( c_2Eextreal_2Eextreal__lt @ V0x @ V2z ) ) ).

thf(thm_2Eextreal_2Ele__total,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
      | ( c_2Eextreal_2Eextreal__le @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Elt__total,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( V0x = V1y )
      | ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
      | ( c_2Eextreal_2Eextreal__lt @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Ele__01,axiom,
    c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Eextreal_2Elt__01,axiom,
    c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Eextreal_2Ene__01,axiom,
    ( (~)
    @ ( ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 )
      = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Eextreal_2Ele__02,axiom,
    c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Eextreal_2Elt__02,axiom,
    c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ).

thf(thm_2Eextreal_2Ene__02,axiom,
    ( (~)
    @ ( ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 )
      = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Eextreal_2Ele__num,axiom,
    ! [V0n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__of__num @ V0n ) ) ).

thf(thm_2Eextreal_2Elt__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
    <=> ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
        & ( (~) @ ( V0x = V1y ) ) ) ) ).

thf(thm_2Eextreal_2Ele__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
    <=> ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
        | ( V0x = V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
      = ( c_2Eextreal_2Eextreal__le @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Elt__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
      = ( c_2Eextreal_2Eextreal__lt @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Ele__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elt__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elet__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elte__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__add2,axiom,
    ! [V0w: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal,V3z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0w @ V1x )
        & ( c_2Eextreal_2Eextreal__le @ V2y @ V3z ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V0w @ V2y ) @ ( c_2Eextreal_2Eextreal__add @ V1x @ V3z ) ) ) ).

thf(thm_2Eextreal_2Elt__add2,axiom,
    ! [V0w: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal,V3z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ V0w @ V1x )
        & ( c_2Eextreal_2Eextreal__lt @ V2y @ V3z ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V0w @ V2y ) @ ( c_2Eextreal_2Eextreal__add @ V1x @ V3z ) ) ) ).

thf(thm_2Eextreal_2Elet__add2,axiom,
    ! [V0w: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal,V3z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0w = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0w = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__le @ V0w @ V1x )
        & ( c_2Eextreal_2Eextreal__lt @ V2y @ V3z ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V0w @ V2y ) @ ( c_2Eextreal_2Eextreal__add @ V1x @ V3z ) ) ) ).

thf(thm_2Eextreal_2Elet__add2__alt,axiom,
    ! [V0w: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal,V3z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1x = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__le @ V0w @ V1x )
        & ( c_2Eextreal_2Eextreal__lt @ V2y @ V3z ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V0w @ V2y ) @ ( c_2Eextreal_2Eextreal__add @ V1x @ V3z ) ) ) ).

thf(thm_2Eextreal_2Ele__addr,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__addr__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y )
     => ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__ladd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V2z ) )
        = ( c_2Eextreal_2Eextreal__le @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Ele__radd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) )
        = ( c_2Eextreal_2Eextreal__le @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Ele__radd__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V1y @ V2z )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) ) ).

thf(thm_2Eextreal_2Ele__ladd__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V1y @ V2z )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V2z ) ) ) ).

thf(thm_2Eextreal_2Elt__ladd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V2z ) )
        = ( c_2Eextreal_2Eextreal__lt @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Elt__radd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) )
        = ( c_2Eextreal_2Eextreal__lt @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Elt__addl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) )
        = ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x ) ) ) ).

thf(thm_2Eextreal_2Ele__lneg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ V1y )
      = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__mul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elet__mul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elte__mul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__mul__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Emul__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Elt__mul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elt__mul__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Emul__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Emul__let,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Emul__lte,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Ele__rmul__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z )
        & ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) @ ( c_2Eextreal_2Eextreal__mul @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Ele__lmul__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z )
        & ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V2z @ V0x ) @ ( c_2Eextreal_2Eextreal__mul @ V2z @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elt__rmul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) @ ( c_2Eextreal_2Eextreal__mul @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elt__lmul,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) )
        = ( c_2Eextreal_2Eextreal__lt @ V1y @ V2z ) ) ) ).

thf(thm_2Eextreal_2Elt__mul2,axiom,
    ! [V0x1: tyop_2Eextreal_2Eextreal,V1x2: tyop_2Eextreal_2Eextreal,V2y1: tyop_2Eextreal_2Eextreal,V3y2: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x1 )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2y1 )
        & ( (~) @ ( V0x1 = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V2y1 = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__lt @ V0x1 @ V1x2 )
        & ( c_2Eextreal_2Eextreal__lt @ V2y1 @ V3y2 ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x1 @ V2y1 ) @ ( c_2Eextreal_2Eextreal__mul @ V1x2 @ V3y2 ) ) ) ).

thf(thm_2Eextreal_2Eabs__pos,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__abs @ V0x ) ) ).

thf(thm_2Eextreal_2Eabs__refl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__abs @ V0x )
        = V0x )
    <=> ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Eextreal_2Eabs__bounds,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1k: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__abs @ V0x ) @ V1k )
    <=> ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__ainv @ V1k ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ V0x @ V1k ) ) ) ).

thf(thm_2Eextreal_2Eabs__bounds__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1k: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__abs @ V0x ) @ V1k )
    <=> ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__ainv @ V1k ) @ V0x )
        & ( c_2Eextreal_2Eextreal__lt @ V0x @ V1k ) ) ) ).

thf(thm_2Eextreal_2Eadd__comm,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__add @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Eadd__assoc,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__add @ V0x @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
      = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ V2z ) ) ).

thf(thm_2Eextreal_2Eadd__not__infty,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__add @ V0x @ V1y )
            = c_2Eextreal_2ENegInf ) ) )
      & ( ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__add @ V0x @ V1y )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__rzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__add @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
      = V0x ) ).

thf(thm_2Eextreal_2Eadd__lzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
      = V0x ) ).

thf(thm_2Eextreal_2Eadd__infty,axiom,
    ( ! [V0x: tyop_2Eextreal_2Eextreal] :
        ( ( ( c_2Eextreal_2Eextreal__add @ V0x @ c_2Eextreal_2EPosInf )
          = c_2Eextreal_2EPosInf )
        & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2EPosInf @ V0x )
          = c_2Eextreal_2EPosInf ) )
    & ! [V1x: tyop_2Eextreal_2Eextreal] :
        ( ( (~) @ ( V1x = c_2Eextreal_2EPosInf ) )
       => ( ( ( c_2Eextreal_2Eextreal__add @ V1x @ c_2Eextreal_2ENegInf )
            = c_2Eextreal_2ENegInf )
          & ( ( c_2Eextreal_2Eextreal__add @ c_2Eextreal_2ENegInf @ V1x )
            = c_2Eextreal_2ENegInf ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__EQ__LADD,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( ( c_2Eextreal_2Eextreal__add @ V0x @ V1y )
          = ( c_2Eextreal_2Eextreal__add @ V0x @ V2z ) )
      <=> ( V1y = V2z ) ) ) ).

thf(thm_2Eextreal_2Esub__rzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__sub @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
      = V0x ) ).

thf(thm_2Eextreal_2Esub__lzero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
      = ( c_2Eextreal_2Eextreal__ainv @ V0x ) ) ).

thf(thm_2Eextreal_2Esub__le__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z ) ) ).

thf(thm_2Eextreal_2Esub__le__imp2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z ) ) ).

thf(thm_2Eextreal_2Ele__sub__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V2z )
     => ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__sub @ V2z @ V0x ) ) ) ).

thf(thm_2Eextreal_2Elt__sub__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V2z )
     => ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__sub @ V2z @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esub__lt__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z ) ) ).

thf(thm_2Eextreal_2Esub__lt__imp2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z ) ) ).

thf(thm_2Eextreal_2Esub__zero__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esub__zero__lt2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Esub__lt__zero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Esub__lt__zero2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
        & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Esub__zero__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esub__le__zero,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ V0x @ V1y )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ) ).

thf(thm_2Eextreal_2Ele__sub__eq,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__sub @ V2z @ V0x ) )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V2z ) ) ) ).

thf(thm_2Eextreal_2Ele__sub__eq2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__sub @ V2z @ V0x ) )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V2z ) ) ) ).

thf(thm_2Eextreal_2Esub__le__eq,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z )
        = ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Esub__le__eq2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z )
        = ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__add @ V2z @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Esub__le__switch,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V2z ) @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esub__le__switch2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) @ V2z )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V2z ) @ V0x ) ) ) ).

thf(thm_2Eextreal_2Elt__sub,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V2z )
        = ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__sub @ V2z @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Esub__add2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__add @ V0x @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) )
        = V1y ) ) ).

thf(thm_2Eextreal_2Eadd__sub,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ V1y )
        = V0x ) ) ).

thf(thm_2Eextreal_2Eadd__sub2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__add @ V1y @ V0x ) @ V1y )
        = V0x ) ) ).

thf(thm_2Eextreal_2Esub__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) @ V1y )
        = V0x ) ) ).

thf(thm_2Eextreal_2Eextreal__sub__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__add @ V0x @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) ) ) ).

thf(thm_2Eextreal_2Esub__0,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
     => ( V0x = V1y ) ) ).

thf(thm_2Eextreal_2Eneg__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) )
      = V0x ) ).

thf(thm_2Eextreal_2Eneg__0,axiom,
    ( ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
    = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ).

thf(thm_2Eextreal_2Eneg__eq0,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__ainv @ V0x )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
    <=> ( V0x
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Eeq__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__ainv @ V0x )
        = ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
    <=> ( V0x = V1y ) ) ).

thf(thm_2Eextreal_2Eneg__minus1,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__ainv @ V0x )
      = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ V0x ) ) ).

thf(thm_2Eextreal_2Esub__rneg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__sub @ V0x @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
      = ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Esub__lneg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) ) )
        | ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ V1y )
        = ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) ) ) ) ).

thf(thm_2Eextreal_2Eneg__sub,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
        | ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) )
        = ( c_2Eextreal_2Eextreal__sub @ V1y @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esub__not__infty,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y )
            = c_2Eextreal_2ENegInf ) ) )
      & ( ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2Ele__lsub__imp,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V1y @ V2z )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V2z ) @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Eeq__sub__ladd__normal,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Erealax_2Ereal] :
      ( ( V0x
        = ( c_2Eextreal_2Eextreal__sub @ V1y @ ( c_2Eextreal_2ENormal @ V2z ) ) )
    <=> ( ( c_2Eextreal_2Eextreal__add @ V0x @ ( c_2Eextreal_2ENormal @ V2z ) )
        = V1y ) ) ).

thf(thm_2Eextreal_2Eeq__sub__radd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y )
          = V2z )
      <=> ( V0x
          = ( c_2Eextreal_2Eextreal__add @ V2z @ V1y ) ) ) ) ).

thf(thm_2Eextreal_2Eeq__sub__ladd,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( V0x
          = ( c_2Eextreal_2Eextreal__sub @ V1y @ V2z ) )
      <=> ( ( c_2Eextreal_2Eextreal__add @ V0x @ V2z )
          = V1y ) ) ) ).

thf(thm_2Eextreal_2Eeq__sub__switch,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Erealax_2Ereal] :
      ( ( V0x
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V2z ) @ V1y ) )
    <=> ( V1y
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V2z ) @ V0x ) ) ) ).

thf(thm_2Eextreal_2Eeq__add__sub__switch,axiom,
    ! [V0a: tyop_2Eextreal_2Eextreal,V1b: tyop_2Eextreal_2Eextreal,V2c: tyop_2Eextreal_2Eextreal,V3d: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1b = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1b = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V2c = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2c = c_2Eextreal_2EPosInf ) ) )
     => ( ( ( c_2Eextreal_2Eextreal__add @ V0a @ V1b )
          = ( c_2Eextreal_2Eextreal__add @ V2c @ V3d ) )
      <=> ( ( c_2Eextreal_2Eextreal__sub @ V0a @ V2c )
          = ( c_2Eextreal_2Eextreal__sub @ V3d @ V1b ) ) ) ) ).

thf(thm_2Eextreal_2Esub__refl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__sub @ V0x @ V0x )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Emul__comm,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__mul @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Emul__assoc,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__mul @ V1y @ V2z ) )
      = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ V2z ) ) ).

thf(thm_2Eextreal_2Emul__not__infty,axiom,
    ( ! [V0c: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal] :
        ( ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0c )
          & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0c ) @ V1y )
            = c_2Eextreal_2ENegInf ) ) )
    & ! [V2c: tyop_2Erealax_2Ereal,V3y: tyop_2Eextreal_2Eextreal] :
        ( ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V2c )
          & ( (~) @ ( V3y = c_2Eextreal_2EPosInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V2c ) @ V3y )
            = c_2Eextreal_2EPosInf ) ) )
    & ! [V4c: tyop_2Erealax_2Ereal,V5y: tyop_2Eextreal_2Eextreal] :
        ( ( ( c_2Ereal_2Ereal__lte @ V4c @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
          & ( (~) @ ( V5y = c_2Eextreal_2ENegInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V4c ) @ V5y )
            = c_2Eextreal_2EPosInf ) ) )
    & ! [V6c: tyop_2Erealax_2Ereal,V7y: tyop_2Eextreal_2Eextreal] :
        ( ( ( c_2Ereal_2Ereal__lte @ V6c @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
          & ( (~) @ ( V7y = c_2Eextreal_2EPosInf ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V6c ) @ V7y )
            = c_2Eextreal_2ENegInf ) ) ) ) ).

thf(thm_2Eextreal_2Emul__not__infty2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) ) )
     => ( ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
            = c_2Eextreal_2ENegInf ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__ldistrib__pos,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__ldistrib__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
        & ( c_2Eextreal_2Eextreal__le @ V2z @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__ldistrib__normal,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
        | ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__ldistrib__normal2,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V0x ) @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__rdistrib__normal,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
        | ( ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V1y @ ( c_2Eextreal_2ENormal @ V0x ) ) @ ( c_2Eextreal_2Eextreal__mul @ V2z @ ( c_2Eextreal_2ENormal @ V0x ) ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__rdistrib__normal2,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) @ ( c_2Eextreal_2ENormal @ V0x ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V1y @ ( c_2Eextreal_2ENormal @ V0x ) ) @ ( c_2Eextreal_2Eextreal__mul @ V2z @ ( c_2Eextreal_2ENormal @ V0x ) ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__ldistrib,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y )
          & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z ) )
        | ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
          & ( c_2Eextreal_2Eextreal__le @ V2z @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eadd__rdistrib,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1y )
          & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z ) )
        | ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
          & ( c_2Eextreal_2Eextreal__le @ V2z @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2z ) @ V0x )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__mul @ V1y @ V0x ) @ ( c_2Eextreal_2Eextreal__mul @ V2z @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2Emul__lneg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ V1y )
      = ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Emul__rneg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
      = ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Eneg__mul2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__ainv @ V0x ) @ ( c_2Eextreal_2Eextreal__ainv @ V1y ) )
      = ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Eadd2__sub2,axiom,
    ! [V0a: tyop_2Eextreal_2Eextreal,V1b: tyop_2Eextreal_2Eextreal,V2c: tyop_2Eextreal_2Eextreal,V3d: tyop_2Eextreal_2Eextreal] :
      ( ( ( ( (~) @ ( V1b = c_2Eextreal_2EPosInf ) )
          & ( (~) @ ( V3d = c_2Eextreal_2EPosInf ) ) )
        | ( ( (~) @ ( V1b = c_2Eextreal_2ENegInf ) )
          & ( (~) @ ( V3d = c_2Eextreal_2ENegInf ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__sub @ V0a @ V1b ) @ ( c_2Eextreal_2Eextreal__sub @ V2c @ V3d ) )
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__add @ V0a @ V2c ) @ ( c_2Eextreal_2Eextreal__add @ V1b @ V3d ) ) ) ) ).

thf(thm_2Eextreal_2Esub__ldistrib,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2Eextreal__sub @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y ) @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Esub__rdistrib,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V2z = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__sub @ V0x @ V1y ) @ V2z )
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eextreal__mul @ V0x @ V2z ) @ ( c_2Eextreal_2Eextreal__mul @ V1y @ V2z ) ) ) ) ).

thf(thm_2Eextreal_2Eextreal__div__eq,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2ENormal @ V0x ) @ ( c_2Eextreal_2ENormal @ V1y ) )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2E_2F @ V0x @ V1y ) ) ) ).

thf(thm_2Eextreal_2Einv__one,axiom,
    ( ( c_2Eextreal_2Eextreal__inv @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Einv__1over,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__inv @ V0x )
      = ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x ) ) ).

thf(thm_2Eextreal_2Ediv__one,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__div @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
      = V0x ) ).

thf(thm_2Eextreal_2Einv__pos,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x ) ) ) ).

thf(thm_2Eextreal_2Erinv__uniq,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
        = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
     => ( V1y
        = ( c_2Eextreal_2Eextreal__inv @ V0x ) ) ) ).

thf(thm_2Eextreal_2Elinv__uniq,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__mul @ V0x @ V1y )
        = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
     => ( V0x
        = ( c_2Eextreal_2Eextreal__inv @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ele__rdiv,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V1y @ ( c_2Eextreal_2ENormal @ V0x ) ) @ V2z )
        = ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__div @ V2z @ ( c_2Eextreal_2ENormal @ V0x ) ) ) ) ) ).

thf(thm_2Eextreal_2Ele__ldiv,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__mul @ V2z @ ( c_2Eextreal_2ENormal @ V0x ) ) )
        = ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__div @ V1y @ ( c_2Eextreal_2ENormal @ V0x ) ) @ V2z ) ) ) ).

thf(thm_2Eextreal_2Elt__rdiv,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V2z )
     => ( ( c_2Eextreal_2Eextreal__lt @ V0x @ ( c_2Eextreal_2Eextreal__div @ V1y @ ( c_2Eextreal_2ENormal @ V2z ) ) )
        = ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2ENormal @ V2z ) ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elt__ldiv,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V2z )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__div @ V0x @ ( c_2Eextreal_2ENormal @ V2z ) ) @ V1y )
        = ( c_2Eextreal_2Eextreal__lt @ V0x @ ( c_2Eextreal_2Eextreal__mul @ V1y @ ( c_2Eextreal_2ENormal @ V2z ) ) ) ) ) ).

thf(thm_2Eextreal_2Elt__rdiv__neg,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Erealax_2Ereal] :
      ( ( c_2Erealax_2Ereal__lt @ V2z @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__div @ V1y @ ( c_2Eextreal_2ENormal @ V2z ) ) @ V0x )
        = ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__mul @ V0x @ ( c_2Eextreal_2ENormal @ V2z ) ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2Ediv__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1y = c_2Eextreal_2ENegInf ) )
        & ( (~)
          @ ( V2z
            = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__div @ V0x @ V2z ) @ ( c_2Eextreal_2Eextreal__div @ V1y @ V2z ) )
        = ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ V2z ) ) ) ).

thf(thm_2Eextreal_2Ele__inv,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__inv @ V0x ) ) ) ).

thf(thm_2Eextreal_2Epow__0,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__pow @ V0x @ c_2Enum_2E0 )
      = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Epow__1,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) )
      = V0x ) ).

thf(thm_2Eextreal_2Epow__2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
      = ( c_2Eextreal_2Eextreal__mul @ V0x @ V0x ) ) ).

thf(thm_2Eextreal_2Epow__zero,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__pow @ V1x @ ( c_2Enum_2ESUC @ V0n ) )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
    <=> ( V1x
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Epow__zero__imp,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
     => ( V1x
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2Ele__pow2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Epow__pos__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ! [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V1n ) ) ) ).

thf(thm_2Eextreal_2Epow__pos__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1n: tyop_2Enum_2Enum] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V1n ) ) ) ).

thf(thm_2Eextreal_2Epow__le,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1x )
        & ( c_2Eextreal_2Eextreal__le @ V1x @ V2y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n ) @ ( c_2Eextreal_2Eextreal__pow @ V2y @ V0n ) ) ) ).

thf(thm_2Eextreal_2Epow__lt,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1x )
        & ( c_2Eextreal_2Eextreal__lt @ V1x @ V2y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__pow @ V1x @ ( c_2Enum_2ESUC @ V0n ) ) @ ( c_2Eextreal_2Eextreal__pow @ V2y @ ( c_2Enum_2ESUC @ V0n ) ) ) ) ).

thf(thm_2Eextreal_2Epow__lt2,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V0n = c_2Enum_2E0 ) )
        & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1x )
        & ( c_2Eextreal_2Eextreal__lt @ V1x @ V2y ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n ) @ ( c_2Eextreal_2Eextreal__pow @ V2y @ V0n ) ) ) ).

thf(thm_2Eextreal_2Epow__le__mono,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1n: tyop_2Enum_2Enum,V2m: tyop_2Enum_2Enum] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ V0x )
        & ( c_2Earithmetic_2E_3C_3D @ V1n @ V2m ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V1n ) @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V2m ) ) ) ).

thf(thm_2Eextreal_2Epow__pos__even,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V1x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n ) )
        = ( c_2Earithmetic_2EEVEN @ V0n ) ) ) ).

thf(thm_2Eextreal_2Epow__neg__odd,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ V1x @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
     => ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
        = ( c_2Earithmetic_2EODD @ V0n ) ) ) ).

thf(thm_2Eextreal_2Eadd__pow2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2Eextreal__add @ V0x @ V1y ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
      = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__pow @ V1y @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V0x ) @ V1y ) ) ) ).

thf(thm_2Eextreal_2Epow__add,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1n: tyop_2Enum_2Enum,V2m: tyop_2Enum_2Enum] :
      ( ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2E_2B @ V1n @ V2m ) )
      = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V1n ) @ ( c_2Eextreal_2Eextreal__pow @ V0x @ V2m ) ) ) ).

thf(thm_2Eextreal_2Epow__mul,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2Eextreal__mul @ V1x @ V2y ) @ V0n )
      = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n ) @ ( c_2Eextreal_2Eextreal__pow @ V2y @ V0n ) ) ) ).

thf(thm_2Eextreal_2Epow__minus1,axiom,
    ! [V0n: tyop_2Enum_2Enum] :
      ( ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2Eextreal__ainv @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Earithmetic_2E_2A @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) @ V0n ) )
      = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Epow__not__infty,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( ( (~) @ ( V1x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V1x = c_2Eextreal_2EPosInf ) ) )
     => ( ( (~)
          @ ( ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n )
            = c_2Eextreal_2ENegInf ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eextreal__pow @ V1x @ V0n )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2Esqrt__pos__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__sqrt @ V0x ) ) ) ).

thf(thm_2Eextreal_2Esqrt__pos__lt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__sqrt @ V0x ) ) ) ).

thf(thm_2Eextreal_2Epow2__sqrt,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ( ( c_2Eextreal_2Eextreal__sqrt @ ( c_2Eextreal_2Eextreal__pow @ V0x @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) )
        = V0x ) ) ).

thf(thm_2Eextreal_2Esqrt__pow2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2Eextreal__sqrt @ V0x ) @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) )
        = V0x )
    <=> ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x ) ) ).

thf(thm_2Eextreal_2Esqrt__mono__le,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
        & ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sqrt @ V0x ) @ ( c_2Eextreal_2Eextreal__sqrt @ V1y ) ) ) ).

thf(thm_2Eextreal_2Elogr__not__infty,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1b: tyop_2Erealax_2Ereal] :
      ( ( ( (~) @ ( V0x = c_2Eextreal_2ENegInf ) )
        & ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) ) )
     => ( ( (~)
          @ ( ( c_2Eextreal_2Eextreal__logr @ V1b @ V0x )
            = c_2Eextreal_2ENegInf ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eextreal__logr @ V1b @ V0x )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2Ehalf__between,axiom,
    ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Eextreal_2Ethirds__between,axiom,
    ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Eextreal_2Ehalf__cancel,axiom,
    ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
    = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Ethird__cancel,axiom,
    ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Efourth__cancel,axiom,
    ( ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
    = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ).

thf(thm_2Eextreal_2Equotient__normal,axiom,
    ! [V0n: tyop_2Enum_2Enum,V1m: tyop_2Enum_2Enum] :
      ( ( c_2Eextreal_2Eextreal__div @ ( c_2Eextreal_2Eextreal__of__num @ V0n ) @ ( c_2Eextreal_2Eextreal__of__num @ V1m ) )
      = ( c_2Eextreal_2ENormal @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ V0n ) @ ( c_2Ereal_2Ereal__of__num @ V1m ) ) ) ) ).

thf(thm_2Eextreal_2Eext__mono__increasing__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eext__mono__increasing @ V0f )
    <=> ! [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0f @ V1n ) @ ( V0f @ ( c_2Enum_2ESUC @ V1n ) ) ) ) ).

thf(thm_2Eextreal_2Eext__mono__decreasing__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eext__mono__decreasing @ V0f )
    <=> ! [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0f @ ( c_2Enum_2ESUC @ V1n ) ) @ ( V0f @ V1n ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__ARCH,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0x )
     => ! [V1y: tyop_2Eextreal_2Eextreal] :
          ( ( (~) @ ( V1y = c_2Eextreal_2EPosInf ) )
         => ? [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ V2n ) @ V0x ) ) ) ) ).

thf(thm_2Eextreal_2ESIMP__REAL__ARCH,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
    ? [V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ V0x @ ( c_2Ereal_2Ereal__of__num @ V1n ) ) ).

thf(thm_2Eextreal_2ESIMP__REAL__ARCH__NEG,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
    ? [V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( c_2Erealax_2Ereal__neg @ ( c_2Ereal_2Ereal__of__num @ V1n ) ) @ V0x ) ).

thf(thm_2Eextreal_2ESIMP__EXTREAL__ARCH,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
     => ? [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ V1n ) ) ) ).

thf(thm_2Eextreal_2EREAL__ARCH__POW,axiom,
    ! [V0x: tyop_2Erealax_2Ereal] :
    ? [V1n: tyop_2Enum_2Enum] : ( c_2Erealax_2Ereal__lt @ V0x @ ( c_2Ereal_2Epow @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V1n ) ) ).

thf(thm_2Eextreal_2EEXTREAL__ARCH__POW,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( (~) @ ( V0x = c_2Eextreal_2EPosInf ) )
     => ? [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__lt @ V0x @ ( c_2Eextreal_2Eextreal__pow @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) @ V1n ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__ARCH__POW__INV,axiom,
    ! [V0e: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V0e )
     => ? [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2ENormal @ ( c_2Ereal_2Epow @ ( c_2Ereal_2E_2F @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ V1n ) ) @ V0e ) ) ).

thf(thm_2Eextreal_2EREAL__LE__MUL__EPSILON,axiom,
    ! [V0x: tyop_2Erealax_2Ereal,V1y: tyop_2Erealax_2Ereal] :
      ( ! [V2z: tyop_2Erealax_2Ereal] :
          ( ( ( c_2Erealax_2Ereal__lt @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V2z )
            & ( c_2Erealax_2Ereal__lt @ V2z @ ( c_2Ereal_2Ereal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
         => ( c_2Ereal_2Ereal__lte @ ( c_2Erealax_2Ereal__mul @ V2z @ V0x ) @ V1y ) )
     => ( c_2Ereal_2Ereal__lte @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Ele__epsilon,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ! [V2e: tyop_2Eextreal_2Eextreal] :
          ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2e )
            & ( (~) @ ( V2e = c_2Eextreal_2EPosInf ) ) )
         => ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__add @ V1y @ V2e ) ) )
     => ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Ele__mul__epsilon,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ! [V2z: tyop_2Eextreal_2Eextreal] :
          ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V2z )
            & ( c_2Eextreal_2Eextreal__lt @ V2z @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
         => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__mul @ V2z @ V0x ) @ V1y ) )
     => ( c_2Eextreal_2Eextreal__le @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__THM,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ ( c_2Epred__set_2EEMPTY @ A_27a ) )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
      & ! [V1e: A_27a,V2s: A_27a > $o] :
          ( ( c_2Epred__set_2EFINITE @ A_27a @ V2s )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ ( c_2Epred__set_2EINSERT @ A_27a @ V1e @ V2s ) )
            = ( c_2Eextreal_2Eextreal__add @ ( V0f @ V1e ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ ( c_2Epred__set_2EDELETE @ A_27a @ V2s @ V1e ) ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__NEG__INF,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( (~)
              @ ( ( V0f @ V2x )
                = c_2Eextreal_2ENegInf ) ) ) )
     => ( (~)
        @ ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
          = c_2Eextreal_2ENegInf ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__POS__INF,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( (~)
              @ ( ( V0f @ V2x )
                = c_2Eextreal_2EPosInf ) ) ) )
     => ( (~)
        @ ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
          = c_2Eextreal_2EPosInf ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__INFTY,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
          & ! [V2x: A_27a] :
              ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
             => ( (~)
                @ ( ( V0f @ V2x )
                  = c_2Eextreal_2ENegInf ) ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
            = c_2Eextreal_2ENegInf ) ) )
      & ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
          & ! [V3x: A_27a] :
              ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V1s )
             => ( (~)
                @ ( ( V0f @ V3x )
                  = c_2Eextreal_2EPosInf ) ) ) )
       => ( (~)
          @ ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
            = c_2Eextreal_2EPosInf ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SING,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1e: A_27a] :
      ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ ( c_2Epred__set_2EINSERT @ A_27a @ V1e @ ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
      = ( V0f @ V1e ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__POS,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2x ) ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SPOS,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ( (~)
          @ ( V1s
            = ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2x ) ) ) )
     => ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IF__ELIM,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1P: A_27a > $o,V2f: A_27a > tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
        & ! [V3x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
           => ( V1P @ V3x ) ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V4x: A_27a] : ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( V1P @ V4x ) @ ( V2f @ V4x ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
          @ V0s )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f @ V0s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__FINITE__SAME,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2p: A_27a] :
          ( ( ( c_2Ebool_2EIN @ A_27a @ V2p @ V0s )
            & ! [V3q: A_27a] :
                ( ( c_2Ebool_2EIN @ A_27a @ V3q @ V0s )
               => ( ( V1f @ V2p )
                  = ( V1f @ V3q ) ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s )
            = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Epred__set_2ECARD @ A_27a @ V0s ) ) @ ( V1f @ V2p ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__FINITE__CONST,axiom,
    ! [A_27a: $tType,V0P: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0P )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2x: tyop_2Eextreal_2Eextreal] :
          ( ! [V3y: A_27a] :
              ( ( V1f @ V3y )
              = V2x )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0P )
            = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Epred__set_2ECARD @ A_27a @ V0P ) ) @ V2x ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ZERO,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V1x: A_27a] : ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 )
          @ V0s )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__0,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( ( V0f @ V2x )
              = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s )
        = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IN__IF,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s )
          = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
            @ ^ [V2x: A_27a] : ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Ebool_2EIN @ A_27a @ V2x @ V0s ) @ ( V1f @ V2x ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
            @ V0s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CMUL,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2c: tyop_2Erealax_2Ereal] :
          ( ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V2c )
            | ! [V3x: A_27a] :
                ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
               => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V1f @ V3x ) ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
              @ ^ [V4x: A_27a] : ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V2c ) @ ( V1f @ V4x ) )
              @ V0s )
            = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V2c ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CMUL2,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1f: A_27a > tyop_2Eextreal_2Eextreal,V2c: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
        & ! [V3x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
           => ( (~)
              @ ( ( V1f @ V3x )
                = c_2Eextreal_2ENegInf ) ) ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V4x: A_27a] : ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V2c ) @ ( V1f @ V4x ) )
          @ V0s )
        = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V2c ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IMAGE,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f_27: A_27a > A_27b] :
          ( ( c_2Epred__set_2EINJ @ A_27a @ A_27b @ V1f_27 @ V0s @ ( c_2Epred__set_2EIMAGE @ A_27a @ A_27b @ V1f_27 @ V0s ) )
         => ! [V2f: A_27b > tyop_2Eextreal_2Eextreal] :
              ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27b @ V2f @ ( c_2Epred__set_2EIMAGE @ A_27a @ A_27b @ V1f_27 @ V0s ) )
              = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ ( c_2Ecombin_2Eo @ A_27a @ tyop_2Eextreal_2Eextreal @ A_27b @ V2f @ V1f_27 ) @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__DISJOINT__UNION,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1s_27: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
        & ( c_2Epred__set_2EFINITE @ A_27a @ V1s_27 )
        & ( c_2Epred__set_2EDISJOINT @ A_27a @ V0s @ V1s_27 ) )
     => ! [V2f: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f @ ( c_2Epred__set_2EUNION @ A_27a @ V0s @ V1s_27 ) )
          = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f @ V0s ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f @ V1s_27 ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EQ__CARD,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V1x: A_27a] : ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Ebool_2EIN @ A_27a @ V1x @ V0s ) @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
          @ V0s )
        = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Epred__set_2ECARD @ A_27a @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INV__CARD__EQ__1,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( ( (~)
          @ ( V0s
            = ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
        & ( c_2Epred__set_2EFINITE @ A_27a @ V0s ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V1x: A_27a] : ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Ebool_2EIN @ A_27a @ V1x @ V0s ) @ ( c_2Eextreal_2Eextreal__inv @ ( c_2Eextreal_2Eextreal__of__num @ ( c_2Epred__set_2ECARD @ A_27a @ V0s ) ) ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) )
          @ V0s )
        = ( c_2Eextreal_2Eextreal__of__num @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INTER__NONZERO,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f
            @ ( c_2Epred__set_2EINTER @ A_27a @ V0s
              @ ^ [V2p: A_27a] : ( c_2Ebool_2E_7E @ ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ ( V1f @ V2p ) @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) ) )
          = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INTER__ELIM,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2s_27: A_27a > $o] :
          ( ! [V3x: A_27a] :
              ( ( (~) @ ( c_2Ebool_2EIN @ A_27a @ V3x @ V2s_27 ) )
             => ( ( V1f @ V3x )
                = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ ( c_2Epred__set_2EINTER @ A_27a @ V0s @ V2s_27 ) )
            = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ZERO__DIFF,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2t: A_27a > $o] :
          ( ! [V3x: A_27a] :
              ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V2t )
             => ( ( V1f @ V3x )
                = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s )
            = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ ( c_2Epred__set_2EDIFF @ A_27a @ V0s @ V2t ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__MONO,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2f_27: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ! [V3x: A_27a] :
              ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
             => ( c_2Eextreal_2Eextreal__le @ ( V1f @ V3x ) @ ( V2f_27 @ V3x ) ) )
         => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f_27 @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__MONO__SET,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o,V2t: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ( c_2Epred__set_2EFINITE @ A_27a @ V2t )
        & ( c_2Epred__set_2ESUBSET @ A_27a @ V1s @ V2t )
        & ! [V3x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V2t )
           => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V3x ) ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V2t ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EQ,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2f_27: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ! [V3x: A_27a] :
              ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
             => ( ( V1f @ V3x )
                = ( V2f_27 @ V3x ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s )
            = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f_27 @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__POS__MEM__LE,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1s: A_27a > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
        & ! [V2x: A_27a] :
            ( ( c_2Ebool_2EIN @ A_27a @ V2x @ V1s )
           => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2x ) ) ) )
     => ! [V3x: A_27a] :
          ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V1s )
         => ( c_2Eextreal_2Eextreal__le @ ( V0f @ V3x ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V0f @ V1s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ADD,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2f_27: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
            @ ^ [V3x: A_27a] : ( c_2Eextreal_2Eextreal__add @ ( V1f @ V3x ) @ ( V2f_27 @ V3x ) )
            @ V0s )
          = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f_27 @ V0s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SUB,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ! [V1f: A_27a > tyop_2Eextreal_2Eextreal,V2f_27: A_27a > tyop_2Eextreal_2Eextreal] :
          ( ( ! [V3x: A_27a] :
                ( ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s )
               => ( (~)
                  @ ( ( V2f_27 @ V3x )
                    = c_2Eextreal_2ENegInf ) ) )
            | ! [V4x: A_27a] :
                ( ( c_2Ebool_2EIN @ A_27a @ V4x @ V0s )
               => ( (~)
                  @ ( ( V2f_27 @ V4x )
                    = c_2Eextreal_2EPosInf ) ) ) )
         => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
              @ ^ [V5x: A_27a] : ( c_2Eextreal_2Eextreal__sub @ ( V1f @ V5x ) @ ( V2f_27 @ V5x ) )
              @ V0s )
            = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s ) @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V2f_27 @ V0s ) ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EXTREAL__SUM__IMAGE,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0s: A_27a > $o,V1s_27: A_27b > $o,V2f: A_27a > A_27b > tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
        & ( c_2Epred__set_2EFINITE @ A_27b @ V1s_27 ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V3x: A_27a] : ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27b @ ( V2f @ V3x ) @ V1s_27 )
          @ V0s )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( tyop_2Epair_2Eprod @ A_27a @ A_27b )
          @ ^ [V4x: tyop_2Epair_2Eprod @ A_27a @ A_27b] : ( V2f @ ( c_2Epair_2EFST @ A_27a @ A_27b @ V4x ) @ ( c_2Epair_2ESND @ A_27a @ A_27b @ V4x ) )
          @ ( c_2Epred__set_2ECROSS @ A_27a @ A_27b @ V0s @ V1s_27 ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NORMAL,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Erealax_2Ereal,V1s: A_27a > $o] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V2x: A_27a] : ( c_2Eextreal_2ENormal @ ( V0f @ V2x ) )
          @ V1s )
        = ( c_2Eextreal_2ENormal @ ( c_2Ereal__sigma_2EREAL__SUM__IMAGE @ A_27a @ V0f @ V1s ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IN__IF__ALT,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1f: A_27a > tyop_2Eextreal_2Eextreal,V2z: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Epred__set_2EFINITE @ A_27a @ V0s )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a @ V1f @ V0s )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a
          @ ^ [V3x: A_27a] : ( c_2Ebool_2ECOND @ tyop_2Eextreal_2Eextreal @ ( c_2Ebool_2EIN @ A_27a @ V3x @ V0s ) @ ( V1f @ V3x ) @ V2z )
          @ V0s ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CROSS__SYM,axiom,
    ! [A_27a: $tType,A_27b: $tType,V0f: ( tyop_2Epair_2Eprod @ A_27a @ A_27b ) > tyop_2Eextreal_2Eextreal,V1s1: A_27a > $o,V2s2: A_27b > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ A_27a @ V1s1 )
        & ( c_2Epred__set_2EFINITE @ A_27b @ V2s2 ) )
     => ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( tyop_2Epair_2Eprod @ A_27a @ A_27b )
          @ ( c_2Epair_2EUNCURRY @ A_27a @ A_27b @ tyop_2Eextreal_2Eextreal
            @ ^ [V3x: A_27a,V4y: A_27b] : ( V0f @ ( c_2Epair_2E_2C @ A_27a @ A_27b @ V3x @ V4y ) ) )
          @ ( c_2Epred__set_2ECROSS @ A_27a @ A_27b @ V1s1 @ V2s2 ) )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( tyop_2Epair_2Eprod @ A_27b @ A_27a )
          @ ( c_2Epair_2EUNCURRY @ A_27b @ A_27a @ tyop_2Eextreal_2Eextreal
            @ ^ [V5y: A_27b,V6x: A_27a] : ( V0f @ ( c_2Epair_2E_2C @ A_27a @ A_27b @ V6x @ V5y ) ) )
          @ ( c_2Epred__set_2ECROSS @ A_27b @ A_27a @ V2s2 @ V1s1 ) ) ) ) ).

thf(thm_2Eextreal_2EEXTREAL__SUM__IMAGE__COUNT,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( V0f @ c_2Enum_2E0 ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( V0f @ c_2Enum_2E0 ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( V0f @ c_2Enum_2E0 ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__add @ ( V0f @ c_2Enum_2E0 ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ c_2Earithmetic_2EZERO ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT1 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) @ ( V0f @ ( c_2Earithmetic_2ENUMERAL @ ( c_2Earithmetic_2EBIT2 @ ( c_2Earithmetic_2EBIT1 @ c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(thm_2Eextreal_2Ele__sup__imp,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( V0p @ V1x )
     => ( c_2Eextreal_2Eextreal__le @ V1x @ ( c_2Eextreal_2Eextreal__sup @ V0p ) ) ) ).

thf(thm_2Eextreal_2Esup__le,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sup @ V0p ) @ V1x )
    <=> ! [V2y: tyop_2Eextreal_2Eextreal] :
          ( ( V0p @ V2y )
         => ( c_2Eextreal_2Eextreal__le @ V2y @ V1x ) ) ) ).

thf(thm_2Eextreal_2Ele__sup,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V1x @ ( c_2Eextreal_2Eextreal__sup @ V0p ) )
    <=> ! [V2y: tyop_2Eextreal_2Eextreal] :
          ( ! [V3z: tyop_2Eextreal_2Eextreal] :
              ( ( V0p @ V3z )
             => ( c_2Eextreal_2Eextreal__le @ V3z @ V2y ) )
         => ( c_2Eextreal_2Eextreal__le @ V1x @ V2y ) ) ) ).

thf(thm_2Eextreal_2Esup__eq,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__sup @ V0p )
        = V1x )
    <=> ( ! [V2y: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V2y )
           => ( c_2Eextreal_2Eextreal__le @ V2y @ V1x ) )
        & ! [V3y: tyop_2Eextreal_2Eextreal] :
            ( ! [V4z: tyop_2Eextreal_2Eextreal] :
                ( ( V0p @ V4z )
               => ( c_2Eextreal_2Eextreal__le @ V4z @ V3y ) )
           => ( c_2Eextreal_2Eextreal__le @ V1x @ V3y ) ) ) ) ).

thf(thm_2Eextreal_2Esup__const,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__sup
        @ ^ [V1y: tyop_2Eextreal_2Eextreal] : ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V1y @ V0x ) )
      = V0x ) ).

thf(thm_2Eextreal_2Esup__const__alt,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1z: tyop_2Eextreal_2Eextreal] :
      ( ( ? [V2x: tyop_2Eextreal_2Eextreal] : ( V0p @ V2x )
        & ! [V3x: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V3x )
           => ( V3x = V1z ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup @ V0p )
        = V1z ) ) ).

thf(thm_2Eextreal_2Esup__const__over__set,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1k: tyop_2Eextreal_2Eextreal] :
      ( ( (~)
        @ ( V0s
          = ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup
          @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal
            @ ^ [V2x: A_27a] : V1k
            @ V0s ) )
        = V1k ) ) ).

thf(thm_2Eextreal_2Esup__num,axiom,
    ( ( c_2Eextreal_2Eextreal__sup
      @ ^ [V0x: tyop_2Eextreal_2Eextreal] :
          ( c_2Ebool_2E_3F @ tyop_2Enum_2Enum
          @ ^ [V1n: tyop_2Enum_2Enum] : ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V0x @ ( c_2Eextreal_2Eextreal__of__num @ V1n ) ) ) )
    = c_2Eextreal_2EPosInf ) ).

thf(thm_2Eextreal_2Esup__le__sup__imp,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1q: tyop_2Eextreal_2Eextreal > $o] :
      ( ! [V2x: tyop_2Eextreal_2Eextreal] :
          ( ( V0p @ V2x )
         => ? [V3y: tyop_2Eextreal_2Eextreal] :
              ( ( V1q @ V3y )
              & ( c_2Eextreal_2Eextreal__le @ V2x @ V3y ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sup @ V0p ) @ ( c_2Eextreal_2Eextreal__sup @ V1q ) ) ) ).

thf(thm_2Eextreal_2Esup__mono,axiom,
    ! [V0p: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1q: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0p @ V2n ) @ ( V1q @ V2n ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V0p @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V1q @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ) ).

thf(thm_2Eextreal_2Esup__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Eextreal_2Eextreal__le @ ( V0f @ V1m ) @ ( V0f @ V2n ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup
          @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
            @ ^ [V3n: tyop_2Enum_2Enum] : ( V0f @ ( c_2Enum_2ESUC @ V3n ) )
            @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
        = ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ) ).

thf(thm_2Eextreal_2Esup__seq,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal,V1l: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__increasing @ V0f )
     => ( ( c_2Eseq_2E_2D_2D_3E @ V0f @ V1l )
      <=> ( ( c_2Eextreal_2Eextreal__sup
            @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
              @ ^ [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2ENormal @ ( V0f @ V2n ) )
              @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
          = ( c_2Eextreal_2ENormal @ V1l ) ) ) ) ).

thf(thm_2Eextreal_2Esup__lt__infty,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o] :
      ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sup @ V0p ) @ c_2Eextreal_2EPosInf )
     => ! [V1x: tyop_2Eextreal_2Eextreal] :
          ( ( V0p @ V1x )
         => ( c_2Eextreal_2Eextreal__lt @ V1x @ c_2Eextreal_2EPosInf ) ) ) ).

thf(thm_2Eextreal_2Esup__max,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1z: tyop_2Eextreal_2Eextreal] :
      ( ( ( V0p @ V1z )
        & ! [V2x: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V2x )
           => ( c_2Eextreal_2Eextreal__le @ V2x @ V1z ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup @ V0p )
        = V1z ) ) ).

thf(thm_2Eextreal_2Esup__add__mono,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1g: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2n ) )
        & ! [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0f @ V3n ) @ ( V0f @ ( c_2Enum_2ESUC @ V3n ) ) )
        & ! [V4n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V1g @ V4n ) )
        & ! [V5n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V1g @ V5n ) @ ( V1g @ ( c_2Enum_2ESUC @ V5n ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup
          @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
            @ ^ [V6n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__add @ ( V0f @ V6n ) @ ( V1g @ V6n ) )
            @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V1g @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ) ) ).

thf(thm_2Eextreal_2Esup__sum__mono,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1s: tyop_2Enum_2Enum > $o] :
      ( ( ( c_2Epred__set_2EFINITE @ tyop_2Enum_2Enum @ V1s )
        & ! [V2i: tyop_2Enum_2Enum] :
            ( ( c_2Ebool_2EIN @ tyop_2Enum_2Enum @ V2i @ V1s )
           => ! [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2i @ V3n ) ) )
        & ! [V4i: tyop_2Enum_2Enum] :
            ( ( c_2Ebool_2EIN @ tyop_2Enum_2Enum @ V4i @ V1s )
           => ! [V5n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0f @ V4i @ V5n ) @ ( V0f @ V4i @ ( c_2Enum_2ESUC @ V5n ) ) ) ) )
     => ( ( c_2Eextreal_2Eextreal__sup
          @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
            @ ^ [V6n: tyop_2Enum_2Enum] :
                ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum
                @ ^ [V7i: tyop_2Enum_2Enum] : ( V0f @ V7i @ V6n )
                @ V1s )
            @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum
          @ ^ [V8i: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ ( V0f @ V8i ) @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
          @ V1s ) ) ) ).

thf(thm_2Eextreal_2Esup__le__mono,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1z: tyop_2Eextreal_2Eextreal] :
      ( ( ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( V0f @ V2n ) @ ( V0f @ ( c_2Enum_2ESUC @ V2n ) ) )
        & ( c_2Eextreal_2Eextreal__lt @ V1z @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) )
     => ? [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ V1z @ ( V0f @ V3n ) ) ) ).

thf(thm_2Eextreal_2Esup__cmul,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1c: tyop_2Erealax_2Ereal] :
      ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1c )
     => ( ( c_2Eextreal_2Eextreal__sup
          @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal
            @ ^ [V2n: A_27a] : ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1c ) @ ( V0f @ V2n ) )
            @ ( c_2Epred__set_2EUNIV @ A_27a ) ) )
        = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1c ) @ ( c_2Eextreal_2Eextreal__sup @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) ) ) ) ).

thf(thm_2Eextreal_2Esup__lt,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > $o,V1y: tyop_2Eextreal_2Eextreal] :
      ( ? [V2x: tyop_2Eextreal_2Eextreal] :
          ( ( V0P @ V2x )
          & ( c_2Eextreal_2Eextreal__lt @ V1y @ V2x ) )
    <=> ( c_2Eextreal_2Eextreal__lt @ V1y @ ( c_2Eextreal_2Eextreal__sup @ V0P ) ) ) ).

thf(thm_2Eextreal_2Esup__lt__epsilon,axiom,
    ! [V0P: tyop_2Eextreal_2Eextreal > $o,V1e: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1e )
        & ? [V2x: tyop_2Eextreal_2Eextreal] :
            ( ( V0P @ V2x )
            & ( (~) @ ( V2x = c_2Eextreal_2ENegInf ) ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eextreal__sup @ V0P )
            = c_2Eextreal_2EPosInf ) ) )
     => ? [V3x: tyop_2Eextreal_2Eextreal] :
          ( ( V0P @ V3x )
          & ( c_2Eextreal_2Eextreal__lt @ ( c_2Eextreal_2Eextreal__sup @ V0P ) @ ( c_2Eextreal_2Eextreal__add @ V3x @ V1e ) ) ) ) ).

thf(thm_2Eextreal_2Einf__le__imp,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( V0p @ V1x )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__inf @ V0p ) @ V1x ) ) ).

thf(thm_2Eextreal_2Ele__inf,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V1x @ ( c_2Eextreal_2Eextreal__inf @ V0p ) )
    <=> ! [V2y: tyop_2Eextreal_2Eextreal] :
          ( ( V0p @ V2y )
         => ( c_2Eextreal_2Eextreal__le @ V1x @ V2y ) ) ) ).

thf(thm_2Eextreal_2Einf__le,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__inf @ V0p ) @ V1x )
    <=> ! [V2y: tyop_2Eextreal_2Eextreal] :
          ( ! [V3z: tyop_2Eextreal_2Eextreal] :
              ( ( V0p @ V3z )
             => ( c_2Eextreal_2Eextreal__le @ V2y @ V3z ) )
         => ( c_2Eextreal_2Eextreal__le @ V2y @ V1x ) ) ) ).

thf(thm_2Eextreal_2Einf__eq,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__inf @ V0p )
        = V1x )
    <=> ( ! [V2y: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V2y )
           => ( c_2Eextreal_2Eextreal__le @ V1x @ V2y ) )
        & ! [V3y: tyop_2Eextreal_2Eextreal] :
            ( ! [V4z: tyop_2Eextreal_2Eextreal] :
                ( ( V0p @ V4z )
               => ( c_2Eextreal_2Eextreal__le @ V3y @ V4z ) )
           => ( c_2Eextreal_2Eextreal__le @ V3y @ V1x ) ) ) ) ).

thf(thm_2Eextreal_2Einf__const,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__inf
        @ ^ [V1y: tyop_2Eextreal_2Eextreal] : ( c_2Emin_2E_3D @ tyop_2Eextreal_2Eextreal @ V1y @ V0x ) )
      = V0x ) ).

thf(thm_2Eextreal_2Einf__const__alt,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1z: tyop_2Eextreal_2Eextreal] :
      ( ( ? [V2x: tyop_2Eextreal_2Eextreal] : ( V0p @ V2x )
        & ! [V3x: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V3x )
           => ( V3x = V1z ) ) )
     => ( ( c_2Eextreal_2Eextreal__inf @ V0p )
        = V1z ) ) ).

thf(thm_2Eextreal_2Einf__const__over__set,axiom,
    ! [A_27a: $tType,V0s: A_27a > $o,V1k: tyop_2Eextreal_2Eextreal] :
      ( ( (~)
        @ ( V0s
          = ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
     => ( ( c_2Eextreal_2Eextreal__inf
          @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal
            @ ^ [V2x: A_27a] : V1k
            @ V0s ) )
        = V1k ) ) ).

thf(thm_2Eextreal_2Einf__suc,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ! [V1m: tyop_2Enum_2Enum,V2n: tyop_2Enum_2Enum] :
          ( ( c_2Earithmetic_2E_3C_3D @ V1m @ V2n )
         => ( c_2Eextreal_2Eextreal__le @ ( V0f @ V2n ) @ ( V0f @ V1m ) ) )
     => ( ( c_2Eextreal_2Eextreal__inf
          @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
            @ ^ [V3n: tyop_2Enum_2Enum] : ( V0f @ ( c_2Enum_2ESUC @ V3n ) )
            @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
        = ( c_2Eextreal_2Eextreal__inf @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) ) ) ) ).

thf(thm_2Eextreal_2Einf__seq,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal,V1l: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Emono__decreasing @ V0f )
     => ( ( c_2Eseq_2E_2D_2D_3E @ V0f @ V1l )
      <=> ( ( c_2Eextreal_2Eextreal__inf
            @ ( c_2Epred__set_2EIMAGE @ tyop_2Enum_2Enum @ tyop_2Eextreal_2Eextreal
              @ ^ [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2ENormal @ ( V0f @ V2n ) )
              @ ( c_2Epred__set_2EUNIV @ tyop_2Enum_2Enum ) ) )
          = ( c_2Eextreal_2ENormal @ V1l ) ) ) ) ).

thf(thm_2Eextreal_2Einf__lt__infty,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o] :
      ( ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2ENegInf @ ( c_2Eextreal_2Eextreal__inf @ V0p ) )
     => ! [V1x: tyop_2Eextreal_2Eextreal] :
          ( ( V0p @ V1x )
         => ( c_2Eextreal_2Eextreal__lt @ c_2Eextreal_2ENegInf @ V1x ) ) ) ).

thf(thm_2Eextreal_2Einf__min,axiom,
    ! [V0p: tyop_2Eextreal_2Eextreal > $o,V1z: tyop_2Eextreal_2Eextreal] :
      ( ( ( V0p @ V1z )
        & ! [V2x: tyop_2Eextreal_2Eextreal] :
            ( ( V0p @ V2x )
           => ( c_2Eextreal_2Eextreal__le @ V1z @ V2x ) ) )
     => ( ( c_2Eextreal_2Eextreal__inf @ V0p )
        = V1z ) ) ).

thf(thm_2Eextreal_2Einf__cminus,axiom,
    ! [A_27a: $tType,V0f: A_27a > tyop_2Eextreal_2Eextreal,V1c: tyop_2Erealax_2Ereal] :
      ( ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V1c ) @ ( c_2Eextreal_2Eextreal__inf @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal @ V0f @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) )
      = ( c_2Eextreal_2Eextreal__sup
        @ ( c_2Epred__set_2EIMAGE @ A_27a @ tyop_2Eextreal_2Eextreal
          @ ^ [V2n: A_27a] : ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2ENormal @ V1c ) @ ( V0f @ V2n ) )
          @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__add,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1g: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ! [V2n: tyop_2Enum_2Enum] :
          ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2n ) )
          & ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V1g @ V2n ) ) )
     => ( ( c_2Eextreal_2Eext__suminf
          @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__add @ ( V0f @ V3n ) @ ( V1g @ V3n ) ) )
        = ( c_2Eextreal_2Eextreal__add @ ( c_2Eextreal_2Eext__suminf @ V0f ) @ ( c_2Eextreal_2Eext__suminf @ V1g ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__cmul,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1c: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ V1c )
        & ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2n ) ) )
     => ( ( c_2Eextreal_2Eext__suminf
          @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__mul @ V1c @ ( V0f @ V3n ) ) )
        = ( c_2Eextreal_2Eextreal__mul @ V1c @ ( c_2Eextreal_2Eext__suminf @ V0f ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__cmul__alt,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1c: tyop_2Erealax_2Ereal] :
      ( ( ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ V1c )
        & ( ! [V2n: tyop_2Enum_2Enum] :
              ( (~)
              @ ( ( V0f @ V2n )
                = c_2Eextreal_2ENegInf ) )
          | ! [V3n: tyop_2Enum_2Enum] :
              ( (~)
              @ ( ( V0f @ V3n )
                = c_2Eextreal_2EPosInf ) ) ) )
     => ( ( c_2Eextreal_2Eext__suminf
          @ ^ [V4n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1c ) @ ( V0f @ V4n ) ) )
        = ( c_2Eextreal_2Eextreal__mul @ ( c_2Eextreal_2ENormal @ V1c ) @ ( c_2Eextreal_2Eext__suminf @ V0f ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__lt__infty,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( ! [V1n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V1n ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eext__suminf @ V0f )
            = c_2Eextreal_2EPosInf ) ) )
     => ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__lt @ ( V0f @ V2n ) @ c_2Eextreal_2EPosInf ) ) ).

thf(thm_2Eextreal_2Eext__suminf__suminf,axiom,
    ! [V0r: tyop_2Enum_2Enum > tyop_2Erealax_2Ereal] :
      ( ( ! [V1n: tyop_2Enum_2Enum] : ( c_2Ereal_2Ereal__lte @ ( c_2Ereal_2Ereal__of__num @ c_2Enum_2E0 ) @ ( V0r @ V1n ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eext__suminf
              @ ^ [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2ENormal @ ( V0r @ V2n ) ) )
            = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eext__suminf
          @ ^ [V3n: tyop_2Enum_2Enum] : ( c_2Eextreal_2ENormal @ ( V0r @ V3n ) ) )
        = ( c_2Eextreal_2ENormal @ ( c_2Eseq_2Esuminf @ V0r ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__mono,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1g: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ! [V2n: tyop_2Enum_2Enum] :
          ( ( (~)
            @ ( ( V1g @ V2n )
              = c_2Eextreal_2ENegInf ) )
          & ( c_2Eextreal_2Eextreal__le @ ( V1g @ V2n ) @ ( V0f @ V2n ) ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eext__suminf @ V1g ) @ ( c_2Eextreal_2Eext__suminf @ V0f ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__sub,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1g: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal] :
      ( ( ! [V2n: tyop_2Enum_2Enum] :
            ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V1g @ V2n ) )
            & ( c_2Eextreal_2Eextreal__le @ ( V1g @ V2n ) @ ( V0f @ V2n ) ) )
        & ( (~)
          @ ( ( c_2Eextreal_2Eext__suminf @ V0f )
            = c_2Eextreal_2EPosInf ) ) )
     => ( ( c_2Eextreal_2Eext__suminf
          @ ^ [V3i: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__sub @ ( V0f @ V3i ) @ ( V1g @ V3i ) ) )
        = ( c_2Eextreal_2Eextreal__sub @ ( c_2Eextreal_2Eext__suminf @ V0f ) @ ( c_2Eextreal_2Eext__suminf @ V1g ) ) ) ) ).

thf(thm_2Eextreal_2Eext__suminf__sum,axiom,
    ! [V0f: tyop_2Enum_2Enum > tyop_2Eextreal_2Eextreal,V1n: tyop_2Enum_2Enum] :
      ( ( ! [V2n: tyop_2Enum_2Enum] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) @ ( V0f @ V2n ) )
        & ! [V3m: tyop_2Enum_2Enum] :
            ( ( c_2Earithmetic_2E_3C_3D @ V1n @ V3m )
           => ( ( V0f @ V3m )
              = ( c_2Eextreal_2Eextreal__of__num @ c_2Enum_2E0 ) ) ) )
     => ( ( c_2Eextreal_2Eext__suminf @ V0f )
        = ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ tyop_2Enum_2Enum @ V0f @ ( c_2Epred__set_2Ecount @ V1n ) ) ) ) ).

thf(thm_2Eextreal_2Emin__le,axiom,
    ! [V0z: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__min @ V1x @ V2y ) @ V0z )
    <=> ( ( c_2Eextreal_2Eextreal__le @ V1x @ V0z )
        | ( c_2Eextreal_2Eextreal__le @ V2y @ V0z ) ) ) ).

thf(thm_2Eextreal_2Emin__le1,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__min @ V0x @ V1y ) @ V0x ) ).

thf(thm_2Eextreal_2Emin__le2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__min @ V0x @ V1y ) @ V1y ) ).

thf(thm_2Eextreal_2Ele__min,axiom,
    ! [V0z: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V0z @ ( c_2Eextreal_2Eextreal__min @ V1x @ V2y ) )
    <=> ( ( c_2Eextreal_2Eextreal__le @ V0z @ V1x )
        & ( c_2Eextreal_2Eextreal__le @ V0z @ V2y ) ) ) ).

thf(thm_2Eextreal_2Emin__le2__imp,axiom,
    ! [V0x1: tyop_2Eextreal_2Eextreal,V1x2: tyop_2Eextreal_2Eextreal,V2y1: tyop_2Eextreal_2Eextreal,V3y2: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__le @ V0x1 @ V2y1 )
        & ( c_2Eextreal_2Eextreal__le @ V1x2 @ V3y2 ) )
     => ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__min @ V0x1 @ V1x2 ) @ ( c_2Eextreal_2Eextreal__min @ V2y1 @ V3y2 ) ) ) ).

thf(thm_2Eextreal_2Emin__refl,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__min @ V0x @ V0x )
      = V0x ) ).

thf(thm_2Eextreal_2Emin__comm,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__min @ V0x @ V1y )
      = ( c_2Eextreal_2Eextreal__min @ V1y @ V0x ) ) ).

thf(thm_2Eextreal_2Emin__infty,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal] :
      ( ( ( c_2Eextreal_2Eextreal__min @ V0x @ c_2Eextreal_2EPosInf )
        = V0x )
      & ( ( c_2Eextreal_2Eextreal__min @ c_2Eextreal_2EPosInf @ V0x )
        = V0x )
      & ( ( c_2Eextreal_2Eextreal__min @ c_2Eextreal_2ENegInf @ V0x )
        = c_2Eextreal_2ENegInf )
      & ( ( c_2Eextreal_2Eextreal__min @ V0x @ c_2Eextreal_2ENegInf )
        = c_2Eextreal_2ENegInf ) ) ).

thf(thm_2Eextreal_2Ele__max,axiom,
    ! [V0z: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ V0z @ ( c_2Eextreal_2Eextreal__max @ V1x @ V2y ) )
    <=> ( ( c_2Eextreal_2Eextreal__le @ V0z @ V1x )
        | ( c_2Eextreal_2Eextreal__le @ V0z @ V2y ) ) ) ).

thf(thm_2Eextreal_2Ele__max1,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ V0x @ ( c_2Eextreal_2Eextreal__max @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Ele__max2,axiom,
    ! [V0x: tyop_2Eextreal_2Eextreal,V1y: tyop_2Eextreal_2Eextreal] : ( c_2Eextreal_2Eextreal__le @ V1y @ ( c_2Eextreal_2Eextreal__max @ V0x @ V1y ) ) ).

thf(thm_2Eextreal_2Emax__le,conjecture,
    ! [V0z: tyop_2Eextreal_2Eextreal,V1x: tyop_2Eextreal_2Eextreal,V2y: tyop_2Eextreal_2Eextreal] :
      ( ( c_2Eextreal_2Eextreal__le @ ( c_2Eextreal_2Eextreal__max @ V1x @ V2y ) @ V0z )
    <=> ( ( c_2Eextreal_2Eextreal__le @ V1x @ V0z )
        & ( c_2Eextreal_2Eextreal__le @ V2y @ V0z ) ) ) ).

%------------------------------------------------------------------------------
